/*
 * Copyright (C) 2007 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* Credits:
 * http://marakana.com/forums/android/android_examples/39.html
 * http://getablogger.blogspot.com/2008/01/android-how-to-post-file-to-php-server.html
 */
package com.example.alpr;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

import android.app.Activity;
import android.content.Context;
import android.hardware.Camera;
import android.hardware.Camera.PictureCallback;
import android.hardware.Camera.PreviewCallback;
import android.hardware.Camera.ShutterCallback;
import android.os.Bundle;
import android.util.Log;
import android.view.KeyEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.Window;
import android.view.WindowManager;
import android.widget.FrameLayout;


// ----------------------------------------------------------------------

public class ALPR extends Activity {
	private static final String LogTag = "ALPR";
	private Preview mPreview;

	/** Called when the activity is first created. */
	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		
		// Get rid of title bar
		getWindow().setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN, WindowManager.LayoutParams.FLAG_FULLSCREEN);
        requestWindowFeature(Window.FEATURE_NO_TITLE);
        
		setContentView(R.layout.main);

		mPreview = new Preview(this);
		((FrameLayout) findViewById(R.id.mPreview)).addView(mPreview);

		Log.d(LogTag, "onCreate'd");
	}
	
	public boolean onKeyUp(int keyCode, KeyEvent event) {
	    if ( (keyCode == KeyEvent.KEYCODE_CAMERA) ) {
	    	mPreview.mCamera.takePicture(shutterCallback, rawCallback, jpegCallback);
	    	Log.d(LogTag,"FINSHED takePicture ROUTINE, RETURNING FROM KEYDOWN");
	    	return true;
	    }	    
	    return super.onKeyDown(keyCode, event);
	}

	ShutterCallback shutterCallback = new ShutterCallback() {
		public void onShutter() {
			Log.d(LogTag, "onShutter'd");
		}
	};

	/** Handles data for raw picture */
	PictureCallback rawCallback = new PictureCallback() {
		public void onPictureTaken(byte[] data, Camera camera) {
			FileOutputStream outStream = null;
			try {
				File f = new File("/sdcard/alpr/test.raw");
				f.createNewFile();
				outStream = new FileOutputStream(f);
				outStream.write(data);
				outStream.close();
				Log.d(LogTag, "onPictureTaken - wrote bytes: " + data.length);
			} catch (FileNotFoundException e) {
				e.printStackTrace();
			} catch (IOException e) {
				e.printStackTrace();
			} catch (NullPointerException e) {
				e.printStackTrace();
			} finally {
			}
			Log.d(LogTag, "onPictureTaken - raw");
		}
	};

	/** Handles data for jpeg picture */
	PictureCallback jpegCallback = new PictureCallback() {
		public void onPictureTaken(byte[] data, Camera camera) {
			FileOutputStream outStream = null;
			try {
				File f = new File("/sdcard/alpr/test.jpg");
				f.createNewFile();
				outStream = new FileOutputStream(f);
				//outStream = openFileOutput("/sdcard/alpr/test.jpg",MODE_PRIVATE);
				outStream.write(data);
				outStream.close();
				Log.d(LogTag, "onPictureTaken - wrote bytes: " + data.length);
			} catch (FileNotFoundException e) {
				e.printStackTrace();
			} catch (IOException e) {
				e.printStackTrace();
			} finally {
				uploadFile("/sdcard/alpr/test.jpg");
				uploadFile("/sdcard/alpr/test.raw");
			}
			Log.d(LogTag, "onPictureTaken - jpg");
		}
	};
    
    public void uploadFile(String fname){
    	try {
    		FileInputStream fis = new FileInputStream(fname);
    		HttpFileUploader htfu = new HttpFileUploader("http://10.32.24.59/server.php","noparamshere", fname);
    		htfu.doStart(fis);
    	} catch (FileNotFoundException e) {
    		// TODO Auto-generated catch block
    		e.printStackTrace();
    	}
    }

}

class Preview extends SurfaceView implements SurfaceHolder.Callback {	
	SurfaceHolder mHolder;
	public Camera mCamera;
	boolean mFinished;

	Preview(Context context) {
		super(context);

		mFinished = false;
		
		// Install a SurfaceHolder.Callback so we get notified when the
		// underlying surface is created and destroyed.
		mHolder = getHolder();
		mHolder.addCallback(this);
		mHolder.setType(SurfaceHolder.SURFACE_TYPE_PUSH_BUFFERS);
	}

	public void surfaceCreated(SurfaceHolder holder) {
		// The Surface has been created, acquire the camera and tell it where
		// to draw.
		mCamera = Camera.open();
		try {
			mCamera.setPreviewDisplay(holder);
			
			mCamera.setPreviewCallback(new PreviewCallback() {
	        	  public void onPreviewFrame(byte[] data, Camera camera)
	        	  {
	        	  }
	           });
		} catch (IOException e) {
			mCamera.release();
			mCamera = null;
			e.printStackTrace();
		}
	}

	public void surfaceDestroyed(SurfaceHolder holder) {
		// Surface will be destroyed when we return, so stop the preview.
		// Because the CameraDevice object is not a shared resource, it's very
		// important to release it when the activity is paused.
		mFinished = true;
		mCamera.setPreviewCallback(null);
		mCamera.stopPreview();
		mCamera.release();
		mCamera = null;
	}

	public void surfaceChanged(SurfaceHolder holder, int format, int w, int h) {
		// Now that the size is known, set up the camera parameters and begin
		// the preview.
		Camera.Parameters parameters = mCamera.getParameters();
		parameters.setPreviewSize(w, h);
		parameters.setFlashMode(Camera.Parameters.FLASH_MODE_ON);
		parameters.setPreviewFrameRate(15);
		parameters.setFocusMode(Camera.Parameters.FOCUS_MODE_AUTO);
		parameters.setSceneMode(Camera.Parameters.SCENE_MODE_AUTO);
		parameters.setWhiteBalance(Camera.Parameters.WHITE_BALANCE_DAYLIGHT);
		parameters.setColorEffect(Camera.Parameters.EFFECT_NONE);
		mCamera.setParameters(parameters);
		mCamera.startPreview();
	}
}