function [ curr_cost ] = myfun( sensor_param )
%MYFUN Summary of this function goes here
%   Detailed explanation goes here


global illuminant_name
global snr
global wave
global num_filters
global lb
global ub
global mean_range



switch num_filters
    
    
    case 2
        
        
        % creating Gaussian functions
        filter1 = (exp(-(wave - sensor_param(1)).^2/(2*sensor_param(3)^2)));
        filter2 = (exp(-(wave - sensor_param(2)).^2/(2*sensor_param(4)^2)));
        
        
        
        % creating sensor from Gaussian functions
        sensor = vertcat(filter1,filter2);
        
        
        
        [xhat,rmse,deltaE]=rectest(sensor,illuminant_name,snr,wave);
        
        
        curr_cost = mean(deltaE);
        
        
    case 3
        
        % creating Gaussian functions
        filter1 = (exp(-(wave - sensor_param(1)).^2/(2*sensor_param(4)^2)));
        filter2 = (exp(-(wave - sensor_param(2)).^2/(2*sensor_param(5)^2)));
        filter3 = (exp(-(wave - sensor_param(3)).^2/(2*sensor_param(6)^2)));
        
        
        % creating sensor from Gaussian functions
        sensor = vertcat(filter1,filter2,filter3);
        
        
        
        [xhat,rmse,deltaE]=rectest(sensor,illuminant_name,snr,wave);
        
        
        curr_cost = mean(deltaE);
        
        
        
    case 4
        
        
        
        % creating Gaussian functions
        filter1 = (exp(-(wave - sensor_param(1)).^2/(2*sensor_param(5)^2)));
        filter2 = (exp(-(wave - sensor_param(2)).^2/(2*sensor_param(6)^2)));
        filter3 = (exp(-(wave - sensor_param(3)).^2/(2*sensor_param(7)^2)));
        filter4 = (exp(-(wave - sensor_param(4)).^2/(2*sensor_param(8)^2)));
        
        
        % creating sensor from Gaussian functions
        sensor = vertcat(filter1,filter2,filter3,filter4);
        
        
        
        [xhat,rmse,deltaE]=rectest(sensor,illuminant_name,snr,wave);
        
        
        curr_cost = mean(deltaE);
        
        
end







end

