#include <cv.h>
#include <cxcore.h>
#include <highgui.h>
#include <vector>

#include <stdio.h>

extern "C" {
#include "sift.h"
#include "imgfeatures.h"
#include "kdtree.h"
#include "utils.h"
#include "xform.h"
}

#define kAvg   "AvgImage.png"

using namespace std;

void simpleAvg( IplImage **imageArray, vector< vector< IplImage* > > imageStore ) {

   unsigned int numImages = imageStore.size();
   
   /* Define a combined image */
   IplImage *combinedImage = cvCreateImage(cvGetSize(imageArray[0]), IPL_DEPTH_8U, 3);

   /* Define a temporary combined image */
   
   /* Sum up each of the pixel values */
   for (unsigned int alignNum=0; alignNum < /*imageStore[0].size()*/ 1; alignNum++) {

     IplImage *tempImage = cvCreateImage(cvGetSize(imageArray[0]), IPL_DEPTH_64F, 3);        

     for (int i=0; i < imageArray[0]->height; i++) {
       for (int j=0; j < imageArray[0]->width; j++) {
         CvScalar val = cvGet2D(imageArray[0], i, j);
         cvSet2D(tempImage, i, j, val);
       }
     }

     for (unsigned int imageNum=0; imageNum < imageStore.size(); imageNum++) {       

       printf("images %d\n", imageNum);

       if( alignNum >= imageStore[imageNum].size() ) {
         continue;
       }

       for (int i=0; i < tempImage->height; i++) {
         for (int j=0; j < tempImage->width; j++) {
           CvScalar oldValue = cvGet2D(tempImage, i, j);           
           CvScalar secondValue = cvGet2D(imageStore[imageNum][alignNum], i, j);
           CvScalar newValue = cvScalar( (oldValue.val[0] + secondValue.val[0]), 
               (oldValue.val[1] + secondValue.val[1]), 
               (oldValue.val[2] + secondValue.val[2]), 
               (oldValue.val[3] + secondValue.val[3]));
           cvSet2D(tempImage, i, j, newValue);
         }
       }
     }

     /* Divide each pixel value by the number of total images */
     for (int i=0; i < imageArray[0]->height; i++) {
       for (int j=0; j < imageArray[0]->width; j++) {
         CvScalar oldValue = cvGet2D(tempImage, i, j);
         CvScalar newValue = cvScalar( (unsigned int)(oldValue.val[0] / numImages), 
             (unsigned int)(oldValue.val[1] / numImages), 
             (unsigned int)(oldValue.val[2] / numImages), 
             (unsigned int)(oldValue.val[3] / numImages));
         cvSet2D(combinedImage, i, j, newValue);
       }
     }

     /* Release the temporary image */
     cvReleaseImage(&tempImage);
   }


   cvSaveImage(kAvg, combinedImage);
   //cvSaveImage( "simpleAvg.jpg", combinedImage );
   //while(1);
}
