#include <cv.h>
#include <cxcore.h>
#include <highgui.h>
#include <vector>

#include <stdio.h>

extern "C" {
#include "sift.h"
#include "imgfeatures.h"
#include "kdtree.h"
#include "utils.h"
#include "xform.h"
}

#define kMatteName   "WeightImage.png"

using namespace std;

void showMatte( vector< vector< double **>* > weights, int height, int width ) {

  IplImage * weightImage = cvCreateImage(cvSize(width, height), IPL_DEPTH_8U, 1);

  for (unsigned int imageNum=0; imageNum < weights.size(); ++imageNum) {
    for (unsigned int alignNum=0; alignNum < weights[imageNum]->size(); ++alignNum) {

      double maxWeight = -1;
      for (int i=0; i < height; i++) {
        for (int j=0; j < width; j++) {
          if( (*weights[ imageNum ])[ alignNum ][ i ][ j ] > maxWeight ) {
            maxWeight = (*weights[ imageNum ])[ alignNum ][ i ][ j ];
          }
        }
      }
      for (int i=0; i < height; i++) {
        for (int j=0; j < width; j++) {
          cvSet2D(weightImage, i, j, cvScalar( (int)((*weights[ imageNum ])[ alignNum ][ i ][ j ] * 255/maxWeight) ));
        }
      }
    }
  }

  cvSaveImage(kMatteName, weightImage);
}
