function number = find_illuminant( img, M)

no_intervals_x = 24;

no_intervals_y = 24;

no_intervals = size(M,1);

chrom_vals = zeros( size(M,1), 1);

img = ieClip(img,0,1);

ycbcr = rgb2ycbcr(img);

x = ycbcr(:,:,2);

y = ycbcr(:,:,3);

x = x.^(1/3);

y = y.^(1/3);

x = round( x * ( no_intervals_x - 1 ) );

y = round( y * ( no_intervals_y - 1) );

ind = x * no_intervals_y + y + 1;

ind = ind(:);

chrom_vals(ind) = 1;

prob_vals = chrom_vals' * M;

number = find( prob_vals == max(prob_vals) );

number = number(1);