clc
clear all

spectrum = 400:10:700;

oi = create_optics();

sensor = create_sensor();

vci = create_vci();

load illuminants_iset.mat

load macbeth_rgb.mat

load transform_sensor.mat


for i = 1:size(illuminants,2)
    
     lightSource = lightSource_create(spectrum, illuminants(:,i) );
 
     scene = initSceneMacbeth(spectrum, lightSource );
  
     scene = sceneAdjustLuminance(scene,61);
        
     scene = sceneSet(scene,'fov',26.5);
        
     oi_scene = oi;
        
     oi_scene = oiCompute(scene,oi_scene);
        
     vcAddAndSelectObject('oi',oi);
        
     sensor_scene = sensor;
        
     sensor_scene = sensorCompute(sensor_scene,oi_scene,0);
       
     vcAddAndSelectObject('sensor',sensor);
        
     vci_scene = vci;
        
     vci_scene = vcimageCompute(vci_scene,sensor_scene);
 
     img = vci_scene.data.sensorspace;
 
     img = img(21:end-20,:,:);
     
     img = imageLinearTransform(img, transform_sensor);
     
     for k = 1:24
    
        ind1 = ceil( k / 6);
    
        ind2 = k - (ind1 - 1) * 6;
    
        patch = img( (ind1 - 1) * 106 + 40 : (ind1 - 1) * 106 + 60 , (ind2 - 1)* 107 + 40 : (ind2 - 1)* 107 + 60, : );
    
        vals(k,:) = [ sum(sum( patch(:,:,1) ) ) / prod( size(patch(:,:,1)))  sum(sum( patch(:,:,2) ) ) / prod( size(patch(:,:,2)))  sum(sum( patch(:,:,3) ) ) / prod( size(patch(:,:,3))) ];
    
     end
    
     transform_matrix{i} = pinv(vals) * macbeth;
 
 
   
end