clc
clear all

load macbeth_rgb.mat

macbeth = macbeth;

spectrum = 400:10:700;

oi = create_optics();

sensor = create_sensor();

vci = create_vci();

load illuminants_iset.mat

i = 4;

lightSource = lightSource_create( spectrum, illuminants(:,4) );

scene_d65 = initSceneMacbeth( spectrum, lightSource);

scene_d65 = sceneAdjustLuminance(scene_d65,61);
        
scene_d65 = sceneSet(scene_d65,'fov',26.5);
        
oi_d65 = oi;
        
oi_d65 = oiCompute(scene_d65,oi_d65);
        
vcAddAndSelectObject('oi',oi_d65);
        
sensor_d65 = sensor;
        
sensor_d65 = sensorCompute(sensor_d65,oi_d65,0);
       
vcAddAndSelectObject('sensor',sensor_d65);
        
vci_d65 = vci;
        
vci_d65 = vcimageCompute(vci_d65,sensor_d65);

img_d65 = vci_d65.data.sensorspace;

img_d65 = img_d65(21:end-20,:,:);



for i = 1:24
    
    ind1 = ceil( i / 6);
    
    ind2 = i - (ind1 - 1) * 6;
    
    patch = img_d65( (ind1 - 1) * 106 + 40 : (ind1 - 1) * 106 + 60 , (ind2 - 1)* 107 + 40 : (ind2 - 1)* 107 + 60, : );
    
    d65_vals(i,:) = [ sum(sum( patch(:,:,1) ) ) / prod( size(patch(:,:,1)))  sum(sum( patch(:,:,2) ) ) / prod( size(patch(:,:,2)))  sum(sum( patch(:,:,3) ) ) / prod( size(patch(:,:,3))) ];
    
end

transform_sensor = pinv( d65_vals ) * macbeth;

save transform_sensor.mat transform_sensor