function lightSource = lightSource_create(spectrum, data)

luminance = 100;

lightSource.name = 'light_source';

lightSource.type = 'scene';

lightSource.temperature = [];

lightSource.luminance = 100;

lightSource.spectrum = struct('wave',spectrum);

binwidth = spectrum(2) - spectrum(1);

photopicLuminosity = vcReadSpectra('data/human/luminosity',spectrum);

SPD = data;

currentL = 683 * binwidth*(photopicLuminosity' * SPD);

illuminantEnergy = (SPD / currentL) * luminance;  %SpectralRadiance

illuminantPhotons = Energy2Quanta(spectrum,illuminantEnergy);

lightSource.data = struct('photons',illuminantPhotons);

return;


