function scene = initScene(spectrum, lightSource, surface_data)

scene.type = 'scene';

scene.spectrum = struct('wave',spectrum');

scene = sceneSet(scene,'distance',1.2);

scene = sceneSet(scene,'magnification',1.0);

scene = sceneSet(scene,'name','created_scene');

temp = zeros(1,1,length(spectrum));

temp(1,1,:) = surface_data;

surface_spd = repmat(temp, [320 480 1] );

[r,c,w] = size(surface_spd);

photons = lightSource.data.photons(:,ones(1,r*c));

photons = reshape(photons,[size(surface_spd,3) c r]);

photons = permute(photons,[3 2 1]);

scene = sceneSet(scene,'cphotons',surface_spd .* photons);

illWave = sceneGet(lightSource,'wave');

energy = Quanta2Energy(sceneGet(lightSource,'wave'),sceneGet(lightSource,'photons'));

scene = sceneSet(scene,'illuminantwave',illWave);

scene = sceneSet(scene,'illuminantdata',energy(:) );

scene = sceneInitGeometry(scene);

scene = sceneInitSpatial(scene);

if checkfields(scene,'data','photons') && ~isempty(scene.data.photons)
    
    [luminance, meanL] = sceneCalculateLuminance(scene);
    
    scene = sceneSet(scene,'luminance',luminance);
    
    scene = sceneSet(scene,'meanLuminance',meanL);
    
    scene = sceneAdjustLuminance(scene,100);
    
end




