function sensor = create_sensor()

voltageSwing = 1.8;  
wellCapacity = 9000; 
fillfactor = 0.45     % fill factor is the product of optical and electrical efficiency
%                       I could also achieve the same result by changing
%                       the filter tranmittance to 0.46 (optical
%                       efficiency) * 0.98 (pixel area) or 0.45
pixelSize = 2.2*1e-6;

% Calculate Conversion Gain
conversiongain = voltageSwing/wellCapacity; % in units of volts/electron

exposureDuration = 0.100 % in seconds
darkvoltage = 1e-005 % units are volts/sec
readnoise = 1.34e-003 % units are volts
dsnu = 14.1e-004 % units are volts
prnu = 0.002218 % units are percent


%% Create the Sensor
sensor = sensorCreate('bayer (gbrg)');

% Read in the spectral sensitivity curves for the sensor
wave = sensorGet(sensor,'wave');
%fullFileName = vcSelectImage;
% read in the measured quantum efficiency for a sensor 
%   see, for example, C:\...\Matlab\ISET-3.0\data\sensor\MeasuredSensorQE.mat
[data,filterNames] = ieReadColorFilter(wave,'C:\Documents and Settings\Shrinivasa Rangan\Desktop\ISET-3.0\data\sensor\MeasuredSensorQE.mat');
sensor = sensorSet(sensor,'filterspectra',data);
sensor = sensorSet(sensor,'filternames',filterNames);
sensor = sensorSet(sensor,'Name','ISETSimulationExample');
vcAddAndSelectObject(sensor);
    
% Set the sensor properties
sensor = sensorSet(sensor,'exposuretime',exposureDuration); % in units of seconds
sensor = sensorSet(sensor,'rows',466);
sensor = sensorSet(sensor,'cols',642);
sensor = sensorSet(sensor,'dsnulevel',dsnu);  %V (0.00172 volts or 1.7 mV
sensor = sensorSet(sensor,'prnulevel',prnu); % specified in %

% Set the pixel properties
pixel =  sensorGet(sensor,'pixel');
pixel = pixelSet(pixel,'size',[pixelSize pixelSize]);   % Pixel Size
pixel = pixelSet(pixel,'conversiongain', conversiongain);        % Volts/e-
pixel = pixelSet(pixel,'voltageswing',voltageSwing); 
pixel = pixelSet(pixel,'darkvoltage',darkvoltage) ;               
pixel = pixelSet(pixel,'readnoisevolts',readnoise);    % units are volts

% Stuff the pixel back into the sensor structure
sensor = sensorSet(sensor,'pixel',pixel);
sensor = pixelCenterFillPD(sensor,fillfactor);

