clc
clear all

%The type of sensor can be modified in create_sensor.
%The sensor matrix can be created through sensor_matrix_create.


cd('C:\Documents and Settings\Shrinivasa Rangan\Desktop\ISET-3.0');

isetPath(pwd);

cd('C:\Documents and Settings\Shrinivasa Rangan\Desktop\psych221_project\create_M_matrix');

load illuminants_iset.mat

load Surface_Reflectances_SimonFraser.mat

load transform_sensor.mat

set(0,'defaultfigurebackingstore','off')

spectrum = 400:10:700;

no_intervals_x = 24;

no_intervals_y = 24;

no_intervals = no_intervals_x * no_intervals_y;

oi = create_optics();

M = ones(no_intervals, size(illuminants,2) );

sensor = create_sensor();

vci = create_vci();

for i = 1:size(illuminants,2)

    lightSource = lightSource_create(spectrum, illuminants(:,i) );
   
    for j = 1:size(Surface_Reflectances,2)
 
        scene = initScene(spectrum, lightSource, Surface_Reflectances(:,j) );
        
        scene = sceneAdjustLuminance(scene,61);
        
        scene = sceneSet(scene,'fov',26.5);
        
        oi_scene = oi;
        
        oi_scene = oiCompute(scene,oi_scene);
        
        vcAddAndSelectObject('oi',oi);
        
        sensor_scene = sensor;
        
        sensor_scene = sensorCompute(sensor_scene,oi_scene,0);
        
        vcAddAndSelectObject('sensor',sensor);
        
        vci_scene = vci;
        
        vci_scene = vcimageCompute(vci_scene,sensor_scene);
         
        img = vci_scene.data.sensorspace;
        
        img = imageLinearTransform( img, transform_sensor);
        
        img = ieClip(img,0,1);
        
        ycbcr = rgb2ycbcr(img);
                
        x = ycbcr(:,:,2);
        
        y = ycbcr(:,:,3);
        
        x = x .^(1/3);
        
        y = y .^(1/3);
        
        x = round( x * ( no_intervals_x - 1 ) );
        
        y = round( y * ( no_intervals_y - 1) );
        
        ind = x * no_intervals_y + y + 1; 
        
        ind = ind(:);
        
        for l = 1:no_intervals
            
              M(l,ind_row) = M(l,ind_row) + length( find( ind == l ) );
            
        end
       
              
    end
    
    save bayes.mat M
    
    
    
end
        
        


