clear;clc;close all;

addpath MNdemosaic BM3D bilateral scielab Pocs

% load data
load 'images/StuffedAnimals.mat' % normalized from 0 to 1

DEMOSAIC{1} = 'bilinear';
DEMOSAIC{2} = 'homogeneity';
DEMOSAIC{3} = 'pocs';

DENOISE{1} = 'simple';      PARAM{1} = [0, 0];
DENOISE{2} = 'cbm3d';       PARAM{2} = [40/255, 0];
DENOISE{3} = 'bilateral';   PARAM{3} = [4, 0.2];

imTrue = imData{1};%(1:240,1:240,:);
imTrueRAW = mosaicRGB(imTrue);
imTrueRAWDecompose = decomposeRAW(imTrueRAW);

% figure('Name','Ground Truth RGB Image'); displayRGB(imTrue);

for i=1:3
    fft_TrueRGB(:,:,i) = fftshift(fft2(fftshift(imTrue(:,:,i))));
    fft_TrueRAW(:,:,i) = fftshift(fft2(fftshift(imTrueRAWDecompose(:,:,i))));
end


h = size(imTrue,1); w = size(imTrue,2);
mask = zeros(h,w); smask = ones(h,w);
mask(h/2-h/4+1:h/2+h/4, w/2+1-w/4:w/2+w/4) = 1;
scale = h*w/ sum(sum(mask(find(mask(:,:)==1))));
mask = mask * scale;
imask = fftshift(ifft2(fftshift(mask)));
smask(2:4:h/2-2, :) = smask(2:4:h/2-2, :) * -1;
smask(h/2+4:4:h, :) = smask(h/2+4:4:h, :) * -1;
smask(:, 2:4:w/2-2) = smask(:, 2:4:w/2-2) * -1;
smask(:, w/2+4:4:w) = smask(:, w/2+4:4:w) * -1;
convmask = smask.*abs(imask);

figure;
subplot(221); imagesc(abs(imask)); colormap('gray');
subplot(222); imagesc(angle(imask)); colormap('gray');
subplot(223); imagesc(smask); colormap('gray');
subplot(224); imagesc(convmask); colormap('gray');

for i=1:3
    recon_TrueRGB(:,:,i) = imfilter(convmask, imTrueRAWDecompose(:,:,i), 'circular', 'same', 'conv');
end

errmask = zeros(h,w);
errmask(find(recon_TrueRGB(:,:,1)==imTrue(:,:,1)))=1;

figure;
subplot(221);displayRGB(imTrue(:,:,1));
subplot(222);displayRGB(imTrueRAWDecompose(:,:,1));
subplot(223);displayRGB(recon_TrueRGB(:,:,1));
subplot(224);imagesc(errmask);



return
for i=1:3
    switch i
        case 1
            figure('Name','FFT of R Channel of True RGB and RAW Images'); 
        case 2
            figure('Name','FFT of G Channel of True RGB and RAW Images'); 
        case 3
            figure('Name','FFT of B Channel of True RGB and RAW Images'); 
    end
    subplot(231); displayRGB(imTrue(:,:,i));
    subplot(232); displayRGB(imTrueRAWDecompose(:,:,i));
    subplot(233); displayRGB(recon_TrueRGB(:,:,i));
    subplot(234); imagesc(abs(fft_TrueRGB(:,:,i)),[0 100]); axis('image'); colormap('gray');
    subplot(235); imagesc(abs(fft_TrueRAW(:,:,i)),[0 100]); axis('image'); colormap('gray');
    subplot(236); imagesc(abs(filter_fft_TrueRAW(:,:,i)),[0 100]); axis('image'); colormap('gray');
end

return


