clear;clc;close all;

addpath scielab

% algorithms
DEMOSAIC{1} = 'bilinear';
DEMOSAIC{2} = 'homogeneity';
DEMOSAIC{3} = 'pocs';
DEMOSAIC{4} = 'frequency';

DENOISE{1} = 'simple';      dn1p1 = [0 0 0 0]; dn1p2 = [0 0 0 0];       % parameters for each noise level
DENOISE{2} = 'cbm3d';       dn2p1 = [1 5 9 13]; dn2p2 = [0 0 0 0];       % p1 - sigma, p2 - don't care
DENOISE{3} = 'bilateral';   dn3p1 = [1 1 1 2]; dn3p2 = [0.05 0.10 0.15 0.20];     % p1 - sigma spatial, p2 - sigma range
DENOISE{4} = 'bls_gsm';     dn4p1 = [2/255 5/255 10/255 15/255]; dn4p2 = [0 0 0 0];   % p1 - sigma, p2 - don't care

dnParam1 = [ dn1p1; dn2p1; dn3p1; dn4p1 ];
dnParam2 = [ dn1p2; dn2p2; dn3p2; dn4p2 ];


[imData fileName] = loadImage(1);
imTRUE = imData{1};  % ref image

% load noisy image
% imPro = imData{1+noiseLevel};
for i=1:4
    % imPro{i} = imnoise(imTRUE, 'gaussian', 0, 0.01*i/3);
    imTrueGray = rgb2gray(imTRUE);
    switch i
        case 1
            xx = 0.0025;
        case 2
            xx = 0.01;
        case 3
            xx = 0.040;
        case 4
            xx = 0.155;
    end
%     noise = imnoise(imTrueGray, 'speckle', 0.01*i*2) - imTrueGray;
    noise = imnoise(imTrueGray, 'speckle', xx) - imTrueGray;

    for j=1:3
        imPro1{i}(:,:,j) = imTRUE(:,:,j) + noise;
%         imPro2{i}(:,:,j) = imTRUE(:,:,j) + imnoise(imTrueGray, 'speckle', 0.01*i*2) - imTrueGray;
        imPro2{i}(:,:,j) = imTRUE(:,:,j) + imnoise(imTrueGray, 'speckle', xx) - imTrueGray;
    end

    mse1(i) = evaluateQuality(imTRUE, imPro1{i}, 'mse');
    mse2(i) = evaluateQuality(imTRUE, imPro2{i}, 'mse');
    mseIn(i) = evaluateQuality(imTRUE, imData{i+1}, 'mse');
    
end

if 0
figure;
subplot(221); displayRGB(imData{2});
subplot(222); displayRGB(imData{3});
subplot(223); displayRGB(imData{4});
subplot(224); displayRGB(imData{5});

figure;
subplot(221); displayRGB(imPro2{1});
subplot(222); displayRGB(imPro2{2});
subplot(223); displayRGB(imPro2{3});
subplot(224); displayRGB(imPro2{4});

% figure;
% subplot(221); displayRGB(imTRUE);
% subplot(222); displayRGB(imPro2{1});
% subplot(223); displayRGB(imPro2{2});
% subplot(224); displayRGB(imPro2{3});

mse1
mse2
mseIn
end

% return

for i=1:4
    for j=1:4
        disp(num2str(i));
        imOut1{i,j} = applyDenoise(imPro1{j}, DENOISE{i}, dnParam1(i, j), dnParam2(i, j));
        imOut2{i,j} = applyDenoise(imPro2{j}, DENOISE{i}, dnParam1(i, j), dnParam2(i, j));
        mseOut1(i,j) = evaluateQuality(imOut1{i,j}, imTRUE, 'mse');
        mseOut2(i,j) = evaluateQuality(imOut2{i,j}, imTRUE, 'mse');
    end
end

mseOut1
mseOut2

for i=1:4
    figure;
    for j=1:4
    subplot(2,4,j); displayRGB(imOut1{i,j});
    subplot(2,4,j+4); displayRGB(imOut2{i,j});
    end
end

figure;
for i=1:4
    A{i}=[mseOut1(i,:); mseOut2(i,:)];
    subplot(1,4,i); bar(A{i}');
    xlabel('Noise Level');
    ylabel('MSE');
    legend('Luminance Noise', 'Color Noise');
    legend('Location', 'NorthWest');
    switch i
        case 1
            title('Simple Linear Filtering');
        case 2
            title('BM3D');
        case 3
            title('Bilateral Filtering');
        case 4
            title('BLS-GSM');
    end
end

figure;
subplot(221); displayRGB(imPro1{4}); axis off;
title('Input with Luminance Noise');
subplot(222); displayRGB(imOut1{2,4}); axis off;
title('BM3D to Luminance Noise');
subplot(223); displayRGB(imPro2{4}); axis off;
title('Input with Color Noise');
subplot(224); displayRGB(imOut2{2,4}); axis off;
title('BM3D to Color Noise');

figure;
subplot(121);displayError(imPro1{4}, imTRUE, 'rgb3D');
title('Luminance Noise');
subplot(122);displayError(imPro2{4}, imTRUE, 'rgb3D');
title('Color Noise');


return










% display settings
displayPlots = true;

% parameter settings
% pipeline type
plType = 'DM2DN';

M = zeros(1*4*4*4, 12);

count = 0;

% image number
for imageNo = 1:1
% select noise level
for noiseLevel = 1:1
% select DN algorithm
for dn = 2:2
    
count = count+1;
disp(sprintf('count = %d', count));

% load data
[imData fileName] = loadImage(imageNo);

% true data
imTRUE = imData{1};  % ref image

% load noisy image
% imPro = imData{1+noiseLevel};
imPro = imnoise(imTrue);

%% stage 1 - demosaic %%
disp('Stage 1 - Demosaic');
tic;
% demosaic images

toc;
%% stage 2 - denoise %%
disp('Stage 2 - Denoise');
tic;
% demosaic images
imProo = applyDenoise(imPro, DENOISE{dn}, dnParam1(dn, noiseLevel), dnParam2(dn, noiseLevel)); % processed image


% display images
if(displayPlots)
    figure('Name', ['[Stage 2] - ' fileName]);
    subplot(131); title('True Image');
    displayRGB(imTRUE);

    subplot(132); title('Parallel Image');
    displayRGB(imPro);

    subplot(133); title('Processed Image');
    displayRGB(imProo);
end
toc;

end % dn
end % noiseLevel

% write to file

end % imageNo