clear;clc;close all;

addpath scielab

% algorithms
DEMOSAIC{1} = 'bilinear';
DEMOSAIC{2} = 'homogeneity';
DEMOSAIC{3} = 'pocs';
DEMOSAIC{4} = 'frequency';

DENOISE{1} = 'simple';      dn1p1 = [0 0 0 0]; dn1p2 = [0 0 0 0];       % parameters for each noise level
DENOISE{2} = 'cbm3d';       dn2p1 = [1 5 9 13]; dn2p2 = [0 0 0 0];       % p1 - sigma, p2 - don't care
DENOISE{3} = 'bilateral';   dn3p1 = [1 1 1 2]; dn3p2 = [0.05 0.10 0.15 0.20];     % p1 - sigma spatial, p2 - sigma range
DENOISE{4} = 'bls_gsm';     dn4p1 = [2/255 5/255 10/255 15/255]; dn4p2 = [0 0 0 0];   % p1 - sigma, p2 - don't care

dnParam1 = [ dn1p1; dn2p1; dn3p1; dn4p1 ];
dnParam2 = [ dn1p2; dn2p2; dn3p2; dn4p2 ];

t{1}='Simple Linear Filter';
t{2}='BM3D';
t{3}='Bilateral Filter';
t{4}='BLS-GSM';

[imData fileName] = loadImage(1);
imTrue = imData{1};  % ref image
imTrueRaw = mosaicRGB(imTrue);


for n=1:4
    errIn_mse(n) = evaluateQuality(imData{n+1}, imTrue, 'mse');
    errIn_sc(n) = evaluateQuality(imData{n+1}, imTrue, 'scielab');
end
    
for n=1:4
    for dn=1:4
        disp(num2str(n));
        imDN{n,dn} = applyDenoise(imData{n+1}, DENOISE{dn}, dnParam1(dn, n), dnParam2(dn, n));
        errDN_mse(n,dn) = evaluateQuality(imDN{n,dn}, imTrue, 'mse');
        errDN_sc(n,dn) = evaluateQuality(imDN{n,dn}, imTrue, 'scielab');
    end
end

for n=1:4
    figure;
    for dn=1:4
        subplot(2,2,dn);displayRGB(imDN{n,dn});
    end
end

figure;
subplot(121); 
bar(errDN_mse); ylabel('MSE'); xlabel('Noise Level');
legend(t{1}, t{2}, t{3}, t{4});
legend('Location', 'NorthWest');
subplot(122);
bar(errDN_sc); ylabel('sCIELAB'); xlabel('Noise Level');
legend(t{1}, t{2}, t{3}, t{4});
legend('Location', 'NorthWest');


range=100;im=2;
figure;
subplot(231); imagesc(abs(getFFT(imData{1}(:,:,2))),[0 range]); axis('image'); colormap('gray'); axis off; title('Clean Image');
subplot(234); imagesc(abs(getFFT(imData{im}(:,:,2))),[0 range]); axis('image'); colormap('gray'); axis off; title('Noisy Image');
subplot(232); imagesc(abs(getFFT(imDN{im,1}(:,:,2))),[0 range]); axis('image'); colormap('gray'); axis off; title(t{1});
subplot(233); imagesc(abs(getFFT(imDN{im,2}(:,:,2))),[0 range]); axis('image'); colormap('gray'); axis off; title(t{2});
subplot(235); imagesc(abs(getFFT(imDN{im,3}(:,:,2))),[0 range]); axis('image'); colormap('gray'); axis off; title(t{3});
subplot(236); imagesc(abs(getFFT(imDN{im,4}(:,:,2))),[0 range]); axis('image'); colormap('gray'); axis off; title(t{4});


figure;
subplot(221); displayRGB(imDN{2,2}); title('BM3D - Noise Level 2'); axis off;
subplot(222); displayRGB(imDN{4,2}); title('BM3D - Noise Level 4'); axis off;
subplot(223); displayRGB(imDN{2,3}); title('Bilateral Filter - Noise Level 2'); axis off;
subplot(224); displayRGB(imDN{4,3}); title('Bilateral Filter - Noise Level 4'); axis off;


return

figure;
subplot(121); displayRGB(imTrue);
subplot(122); displayRAW(imTrueRaw);

figure;
for i=1:3
    subplot(2,2,i);
    displayRGB(imDM{i});
    title(t{i});
end

figure;
subplot(121); bar(errDM_mse); ylabel('MSE');
subplot(122); bar(errDM_sc); ylabel('sCIELAB');

figure;
for i=1:3
    subplot(2,2,i);
    displayError(imDM{i}, imTrue, 'rgb3D');
    title(t{i});
end
