clear;clc;close all;

addpath scielab

% algorithms
DEMOSAIC{1} = 'bilinear';
DEMOSAIC{2} = 'homogeneity';
DEMOSAIC{3} = 'pocs';
DEMOSAIC{4} = 'frequency';

DENOISE{1} = 'simple';      dn1p1 = [0 0 0 0]; dn1p2 = [0 0 0 0];       % parameters for each noise level
DENOISE{2} = 'cbm3d';       dn2p1 = [1 5 9 13]; dn2p2 = [0 0 0 0];       % p1 - sigma, p2 - don't care
DENOISE{3} = 'bilateral';   dn3p1 = [1 1 1 2]; dn3p2 = [0.05 0.10 0.15 0.20];     % p1 - sigma spatial, p2 - sigma range
DENOISE{4} = 'bls_gsm';     dn4p1 = [2/255 5/255 10/255 15/255]; dn4p2 = [0 0 0 0];   % p1 - sigma, p2 - don't care

dnParam1 = [ dn1p1; dn2p1; dn3p1; dn4p1 ];
dnParam2 = [ dn1p2; dn2p2; dn3p2; dn4p2 ];

t{1}='Bilinear';
t{2}='Adaptive Homogeneity';
t{3}='POCS';
t{4}='Adaptive Frequency Domain';

[imData fileName] = loadImage(8);
imTrue = imData{1};  % ref image
imTrueRaw = mosaicRGB(imTrue);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% compare DM(#3) and DM(#2)

for dm=1:4
    imDMclean{dm} = applyDemosaic(imTrueRaw, DEMOSAIC{dm});
    if dm==4
        imDMclean{4}(find(isnan(imDMclean{4})==1))=0;
    end
end

for n=1:4
    errDM0_mse(n) = evaluateQuality(imTrueRaw, imData{n+5}, 'mse');
    errDM0_sc(n) = evaluateQuality(imTrueRaw, imData{n+5}, 'scielab');
end

errDM0_mse

for dm=1:4
    for n=1:4
        imDM{dm,n} = applyDemosaic(imData{n+5}, DEMOSAIC{dm});
        if dm==4
            imDM{4}(find(isnan(imDM{4})==1))=0;
        end
        errDM_mse(dm,n) = evaluateQuality(imDM{dm,n}, imDMclean{dm}, 'mse');
        errDM_sc(dm,n) = evaluateQuality(imDM{dm,n}, imDMclean{dm}, 'scielab');
    end
end

errDM_mse

% figure;
% for i=1:4
%     subplot(2,2,i);
%     displayRGB(imDM{i});
%     title(t{i}); axis off;
% end
% 
% figure;
% for i=1:4
%     subplot(2,2,i);
%     displayError(imDM{i}, imDMclean{i}, 'rgb3D');
%     title(t{i});
% end

return

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% compare #1 and DM(#2)

% for dm=1:4
%     imDM{dm} = applyDemosaic(imTrueRaw, DEMOSAIC{dm});
%     if dm==4
%         imDM{4}(find(isnan(imDM{4})==1))=0;
%     end
%     errDM_mse(dm) = evaluateQuality(imDM{dm}, imTrue, 'mse');
%     errDM_sc(dm) = evaluateQuality(imDM{dm}, imTrue, 'scielab');
% end
% 
% figure;
% subplot(131); displayRGB(imDM{1}); axis off; title('Bilinear Demosaic');
% subplot(132); displayError(imDM{1}, imTrue, 'errorImage'); axis off; title('Error Image');
% 
% figure;
% displayError(imDM{1}, imTrue, 'autocorPatch'); axis off;
% subplot(133); title('Autocorrelation Sum of Patches (Blue)');
% 
% return
% 
% 
% 
% % figure;
% % subplot(121); displayRGB(imTrue);
% % subplot(122); displayRAW(imTrueRaw);
% 
% figure;
% for i=1:4
%     subplot(2,2,i);
%     displayRGB(imDM{i});
%     title(t{i}); axis off;
% end
% 
% figure;
% subplot(121); bar(errDM_mse); ylabel('MSE'); title('Demosaic Artifacts');
% subplot(122); bar(errDM_sc); ylabel('sCIELAB'); title('Demosaic Artifacts');
% 
% figure;
% for i=1:4
%     subplot(2,2,i);
%     displayError(imDM{i}, imTrue, 'rgb3D');
%     title(t{i});
% end
% 
% figure;
% displayError(imDM{1}, imTrue, 'rgbPlane');
% 
