clear;clc;close all;

addpath scielab

% algorithms
DEMOSAIC{1} = 'bilinear';
DEMOSAIC{2} = 'homogeneity';
DEMOSAIC{3} = 'pocs';
DEMOSAIC{4} = 'frequency';

DENOISE{1} = 'simple';      dn1p1 = [0 0 0 0]; dn1p2 = [0 0 0 0];       % parameters for each noise level
DENOISE{2} = 'cbm3d';       dn2p1 = [1 5 9 13]; dn2p2 = [0 0 0 0];       % p1 - sigma, p2 - don't care
DENOISE{3} = 'bilateral';   dn3p1 = [1 1 1 2]; dn3p2 = [0.05 0.10 0.15 0.20];     % p1 - sigma spatial, p2 - sigma range
DENOISE{4} = 'bls_gsm';     dn4p1 = [2/255 5/255 10/255 15/255]; dn4p2 = [0 0 0 0];   % p1 - sigma, p2 - don't care

dnParam1 = [ dn1p1; dn2p1; dn3p1; dn4p1 ];
dnParam2 = [ dn1p2; dn2p2; dn3p2; dn4p2 ];


[imData fileName] = loadImage(1);
imTrue = imData{1};  % ref image

figure;
for i=1:4
    subplot(2,2,i);
    displayRGB(imData{i+1}); axis off;
    title(['Noise Level ' num2str(i)]);
end

figure;
for i=1:4
    subplot(2,2,i);
    displayError(imData{i+1}, imTrue, 'rgb3D');
    title(['Noise Level ' num2str(i)]);
end

figure;
for i=1:4
    subplot(2,2,i);
    displayError(imData{i+1}, imTrue, 'viPlot');
    title(['Noise Level ' num2str(i)]);
end



