% This file collects the MSE and sCIELAB values for each setting
% in the Demosaic-Denoise pipeline and saves the data in a CSV file.
clear;clc;close all;

addpath scielab

% algorithms
DEMOSAIC{1} = 'bilinear';
DEMOSAIC{2} = 'homogeneity';
DEMOSAIC{3} = 'pocs';
DEMOSAIC{4} = 'frequency';

DENOISE{1} = 'simple';      dn1p1 = [0 0 0 0]; dn1p2 = [0 0 0 0];       % parameters for each noise level
DENOISE{2} = 'cbm3d';       dn2p1 = [1 5 9 13]; dn2p2 = [0 0 0 0];       % p1 - sigma, p2 - don't care
DENOISE{3} = 'bilateral';   dn3p1 = [1 1 1 2]; dn3p2 = [0.05 0.10 0.15 0.20];     % p1 - sigma spatial, p2 - sigma range
DENOISE{4} = 'bls_gsm';     dn4p1 = [2/255 5/255 10/255 15/255]; dn4p2 = [0 0 0 0];   % p1 - sigma, p2 - don't care

dnParam1 = [ dn1p1; dn2p1; dn3p1; dn4p1 ];
dnParam2 = [ dn1p2; dn2p2; dn3p2; dn4p2 ];

% display settings
displayPlots = true;

% parameter settings
% pipeline type
plType = 'DM2DN';

M = zeros(1*4*3*4, 16);

count = 0;

% image number
for imageNo = 1:7
fc = 0;
% select noise level
for noiseLevel = 1:4
% select DM algorithm
for dm = 1:3
% select DN algorithm
for dn = 1:4
    
count = count+1;
fc = fc+1;
disp(sprintf('count = %d', count));

% save settings
M(fc, 1) = imageNo;
M(fc, 2) = noiseLevel;
M(fc, 3) = dm;
M(fc, 4) = dn;

% load data
[imData fileName] = loadImage(imageNo);

% true data
imTRUE = imData{1};  % ref image
imRAW = mosaicRGB(imData{1});   % clean raw image

% load noisy image
imPro = imData{5+noiseLevel};

%% stage 1 - demosaic %%
disp('Stage 1 - Demosaic');
tic;
% demosaic images
imPar = applyDemosaic(imRAW, DEMOSAIC{dm}); % parallel processed clean image
imPro = applyDemosaic(imPro, DEMOSAIC{dm}); % processed image

% calculate errors
% 1. Clean image errors
mse = evaluateQuality(imTRUE, imPar, 'mse');
scielab = evaluateQuality(imTRUE, imPar, 'scielab');
M(fc, 5) = mse;
M(fc, 6) = scielab;

% 2. True image errors
mse = evaluateQuality(imTRUE, imPro, 'mse');
scielab = evaluateQuality(imTRUE, imPro, 'scielab');
M(fc, 7) = mse;
M(fc, 8) = scielab;

% 3. Parallel image errors
mse = evaluateQuality(imPar, imPro, 'mse');
scielab = evaluateQuality(imPar, imPro, 'scielab');
M(fc, 9) = mse;
M(fc, 10) = scielab;

% display images
if(displayPlots)
    figure('Name', ['[Stage 1] - ' fileName]);
    subplot(131); title('True Image');
    displayRGB(imTRUE);

    subplot(132); title('Parallel Image');
    displayRGB(imPar);

    subplot(133); 
    figure; 
    displayRGB(imPro);
    title('Processed Image');
end
toc;

imPro1 = imPro;

%% stage 2 - denoise %%
disp('Stage 2 - Denoise');
tic;
% demosaic images
imPar = applyDenoise(imPar, DENOISE{dn}, dnParam1(dn, noiseLevel), dnParam2(dn, noiseLevel)); % parallel processed clean image
imPro = applyDenoise(imPro, DENOISE{dn}, dnParam1(dn, noiseLevel), dnParam2(dn, noiseLevel)); % processed image

% calculate errors
% 1. Clean image errors
mse = evaluateQuality(imTRUE, imPar, 'mse');
scielab = evaluateQuality(imTRUE, imPar, 'scielab');
M(fc, 11) = mse;
M(fc, 12) = scielab;

% 2. True image errors
mse = evaluateQuality(imTRUE, imPro, 'mse');
scielab = evaluateQuality(imTRUE, imPro, 'scielab');
M(fc, 13) = mse;
M(fc, 14) = scielab;

% 3. Parallel image errors
mse = evaluateQuality(imPar, imPro, 'mse');
scielab = evaluateQuality(imPar, imPro, 'scielab');
M(fc, 15) = mse;
M(fc, 16) = scielab;

% display images
if(displayPlots)
    figure('Name', ['[Stage 2] - ' fileName]);
    subplot(131); title('True Image');
    displayRGB(imTRUE);

    subplot(132); title('Parallel Image');
    displayRGB(imPar);

    subplot(133); title('Processed Image');
    displayRGB(imPro);
end
toc;

end % dn
end % dm
end % noiseLevel

% write to file
csvwrite([plType '_' fileName '.csv'], M);
disp(['saved to file: ' plType '_' fileName '.csv']);

end % imageNo