clear;clc;close all

addpath images

% function imOut = iset_get_images(inputtype, filename, cfatype, noisetype, gain)
% inputtype : 'file', 'patern'
% cfatype   : 'raw', 'rgb'
% noisetype : 'none', 'photon', 'additive', 'multiplicative', 'all'
% gain      : the bigger gain, the noisier output ( 0: use default setting) 

if 0
    
imOut = iset_get_images('file', 'images/StuffedAnimals_tungsten-hdrs.mat', 'rgb', 'all', [2:2:8]);

for i=1:length(imOut)
    figure(1); subplot(2,ceil(length(imOut)/2),i); displayRGB(imOut{i});
%     imwrite(imOut{i},['StuffedAnimals' num2str(i) '.png'],'png');
end

end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

imFile{1} = cell2mat( iset_get_images('pattern', 'macbethd65', 'rgb', 'all', 0) );
imFile{2} = cell2mat( iset_get_images('pattern', 'ringsRays', 'rgb', 'all', 0) );
imFile{3} = cell2mat( iset_get_images('pattern', 'harmonic', 'rgb', 'all', 0) );
imFile{4} = cell2mat( iset_get_images('pattern', 'sweepFrequency', 'rgb', 'all', 0) );
imFile{5} = cell2mat( iset_get_images('pattern', 'lined65', 'rgb', 'all', 0) );
imFile{6} = cell2mat( iset_get_images('pattern', 'lineee', 'rgb', 'all', 0) );
imFile{7} = cell2mat( iset_get_images('pattern', 'pointArray', 'rgb', 'all', 0) );
imFile{8} = cell2mat( iset_get_images('pattern', 'gridlines', 'rgb', 'all', 0) );
imFile{9} = cell2mat( iset_get_images('pattern', 'checkerboard', 'rgb', 'all', 0) );

imFile{10} = cell2mat( iset_get_images('pattern', 'frequencyOrientation', 'rgb', 'all', 0) );
imFile{11} = cell2mat( iset_get_images('pattern', 'slantedEdge', 'rgb', 'all', 0) );
imFile{12} = cell2mat( iset_get_images('pattern', 'zonePlate', 'rgb', 'all', 0) );
imFile{13} = cell2mat( iset_get_images('pattern', 'starPattern', 'rgb', 'all', 0) );
imFile{14} = cell2mat( iset_get_images('pattern', 'linearIntensityRamp', 'rgb', 'all', 0) );
imFile{15} = cell2mat( iset_get_images('pattern', 'uniformEqualEnergy', 'rgb', 'all', 0) );
imFile{16} = cell2mat( iset_get_images('pattern', 'uniformEqualPhoton', 'rgb', 'all', 0) );
imFile{17} = cell2mat( iset_get_images('pattern', 'uniformd65', 'rgb', 'all', 0) );
imFile{18} = cell2mat( iset_get_images('pattern', 'whitenoise', 'rgb', 'all', 0) );

for i=1:9
    figure(2); subplot(3,3,i); displayRGB(imFile{i});
end

for i=1:9
    figure(3); subplot(3,3,i); displayRGB(imFile{i+9});
end





%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

if 0
    
addpath MNdemosaic BM3D bilateral scielab Pocs

% Major TODOs:
% 1. print out stage in console

% load data
% load 'RAW.mat' % normalized from 0 to 1
% load 'TRUE.mat' % normalized from 0 to 1
% load 'TRUE_all.mat' % normalized from 0 to 1
% load 'TRUE_add.mat' % normalized from 0 to 1
% load 'TRUE_mult.mat' % normalized from 0 to 1
% load 'TRUE_photon.mat' % normalized from 0 to 1
% load 'TRUE_clean.mat' % normalized from 0 to 1

TRUE_all = iset_get_images('images/StuffedAnimals_tungsten-hdrs.mat', 'rgb', 'all', 0);
TRUE_add = iset_get_images('images/StuffedAnimals_tungsten-hdrs.mat', 'rgb', 'additive', 0);
TRUE_mult = iset_get_images('images/StuffedAnimals_tungsten-hdrs.mat', 'rgb', 'multiplicative', 0);
TRUE_photon = iset_get_images('images/StuffedAnimals_tungsten-hdrs.mat', 'rgb', 'photon', 0);
TRUE_clean = iset_get_images('images/StuffedAnimals_tungsten-hdrs.mat', 'rgb', 'none', 0);

DEMOSAIC{1} = 'bilinear';
DEMOSAIC{2} = 'homogeneity';
DEMOSAIC{3} = 'pocs';

DENOISE{1} = 'simple';      PARAM{1} = [0, 0];
DENOISE{2} = 'bm3d';        PARAM{2} = [20/255, 0];
DENOISE{3} = 'bilateral';   PARAM{3} = [4, 0.2];

% imTrue = TRUE;
% imTrueRAW = mosaicRGB(imTrue);

imErr{1} = cell2mat(TRUE_photon) - cell2mat(TRUE_clean);
imErr{2} = cell2mat(TRUE_add) - cell2mat(TRUE_clean);
imErr{3} = cell2mat(TRUE_mult) - cell2mat(TRUE_clean);
imErr{4} = cell2mat(TRUE_all) - cell2mat(TRUE_clean);

imErrG{1} = imErr{1}(:,:,2);
imErrG{2} = imErr{2}(:,:,2);
imErrG{3} = imErr{3}(:,:,2);
imErrG{4} = imErr{4}(:,:,2);

MSE{1} = norm(imErrG{1}(:))^2;
MSE{2} = norm(imErrG{2}(:))^2;
MSE{3} = norm(imErrG{3}(:))^2;
MSE{4} = norm(imErrG{4}(:))^2;

figure;
subplot(221);imagesc(imErrG{1});axis('image');colormap('gray'); title('photon noise');
subplot(222);imagesc(imErrG{2});axis('image');colormap('gray'); title('additive noise');
subplot(223);imagesc(imErrG{3});axis('image');colormap('gray'); title('multiplicative noise');
subplot(224);imagesc(imErrG{4});axis('image');colormap('gray'); title('all noise');
 
figure;
subplot(221);hist(imErrG{1}(:),200); title('photon noise');
subplot(222);hist(imErrG{2}(:),200); title('additive noise');
subplot(223);hist(imErrG{3}(:),200); title('multiplicative noise');
subplot(224);hist(imErrG{4}(:),200); title('all noise');

[MSE{1} MSE{2} MSE{3} MSE{4}]


end

