clear;clc;close all

% SCENE ###############################
% #####################################

fullFileName = 'C:\Documents\2008_winter\psych221\ISET-3.0\data\images\multispectral\StuffedAnimals_tungsten-hdrs.mat';
scene = sceneFromFile(fullFileName,'multispectral');
scene = sceneAdjustLuminance(scene,61); % This sets the mean scene luminance
scene = sceneSet(scene,'fov',26.5); % match the scene field of view (fov) with the sensor fov
% vcAddAndSelectObject('scene',scene); sceneWindow; % display sceneWindow

% OPTICS ##############################
% #####################################

oi = oiCreate;
optics = oiGet(oi,'optics'); %
optics = opticsSet(optics,'fnumber',4);
optics = opticsSet(optics,'offaxis','skip');
%optics = opticsSet(optics,'offaxis','cos4th');
optics = opticsSet(optics,'focallength',3e-3);
oi = oiSet(oi,'optics',optics);
oi = oiCompute(scene,oi);
% vcAddAndSelectObject('oi',oi); oiWindow;

% SENSOR ##############################
% #####################################

% sensorCreate function is edited to deal with the following CFA patterns.
PATTERN{1}='bayer (rrrr)';
PATTERN{2}='bayer (gggg)';
PATTERN{3}='bayer (bbbb)';


voltageSwing = 1.8;  
wellCapacity = 9000; 
fillfactor = 0.45;     % fill factor is the product of optical and electrical efficiency
%                       I could also achieve the same result by changing
%                       the filter tranmittance to 0.46 (optical
%                       efficiency) * 0.98 (pixel area) or 0.45
pixelSize = 2.2*1e-6;
conversiongain = voltageSwing/wellCapacity; % in units of volts/electron
exposureDuration = 0.100; % in seconds
darkvoltage = 1e-005; % units are volts/sec
readnoise = 1.34e-003; % units are volts
dsnu = 14.1e-004; % units are volts
prnu = 0.002218; % units are percent

% darkvoltage = 0; % units are volts/sec
% readnoise = 0; % units are volts
% dsnu = 0; % units are volts
% prnu = 0; % units are percent


for k=1:3


sensor = sensorCreate(PATTERN{k});
wave = sensorGet(sensor,'wave'); % Read in the spectral sensitivity curves for the sensor
fullFileName = 'C:\Documents\2008_winter\psych221\ISET-3.0\data\sensor\MeasuredSensorQE.mat';
[data,filterNames] = ieReadColorFilter(wave,fullFileName);

sensor = sensorSet(sensor,'filterspectra',data);
sensor = sensorSet(sensor,'filternames',filterNames);
sensor = sensorSet(sensor,'Name','ISETSimulationExample');
sensor = sensorSet(sensor,'exposuretime',exposureDuration); % in units of seconds
sensor = sensorSet(sensor,'rows',466);
sensor = sensorSet(sensor,'cols',642);
sensor = sensorSet(sensor,'dsnulevel',dsnu);  %V (0.00172 volts or 1.7 mV
sensor = sensorSet(sensor,'prnulevel',prnu); % specified in %
pixel =  sensorGet(sensor,'pixel');
pixel = pixelSet(pixel,'size',[pixelSize pixelSize]);   % Pixel Size
pixel = pixelSet(pixel,'conversiongain', conversiongain);        % Volts/e-
pixel = pixelSet(pixel,'voltageswing',voltageSwing); 
pixel = pixelSet(pixel,'darkvoltage',darkvoltage) ;               
pixel = pixelSet(pixel,'readnoisevolts',readnoise);    % units are volts

% sensor = sensorSet(sensor,'shotNoiseFlag',0);

sensor = sensorSet(sensor,'pixel',pixel);
sensor = pixelCenterFillPD(sensor,fillfactor);
sensor = sensorCompute(sensor,oi);
% vcAddAndSelectObject('sensor',sensor); sensorImageWindow;

% IMAGE ###############################
% #####################################

vci = vcImageCreate;
vci = imageSet(vci,'name','default');
vci = imageSet(vci,'scaledisplay',1);
vci = imageSet(vci,'renderGamma',0.6);
% vci = imageSet(vci,'demosaicmethod','bilinear');
% vci = imageSet(vci,'colorbalancemethod','none');
vci = vcimageCompute(vci,sensor);
% vcAddAndSelectObject(vci); vcimageWindow;

im_RGB(:,:,k) = vci.data.input / vci.data.max;

end

figure; 
subplot(221); displayRGB(im_RGB(:,:,1));
subplot(222); displayRGB(im_RGB(:,:,2));
subplot(223); displayRGB(im_RGB(:,:,3));
subplot(224); displayRGB(im_RGB);

TRUE_all=im_RGB;
save 'TRUE_all.mat' TRUE_all

% for i=1:length(FACTOR)
%     figure(1); subplot(2,ceil(length(FACTOR)/2),i); imagesc(im_RAW{i},[0 1]); axis('image'); colormap('gray');
%     imwrite(im_RAW{i},['RAW_a' num2str(i) '.png'],'png');
% end
% RAW=im_RAW;
% save 'RAW.mat' RAW

