function imOut = iset_get_sensorimages(oi, cfatype, noisetype, gain, width, height)

% SENSOR ##############################
% #####################################

% sensorCreate function is edited to deal with the following CFA patterns.
PATTERN{1}='bayer (rrrr)';
PATTERN{2}='bayer (gggg)';
PATTERN{3}='bayer (bbbb)';
% PATTERN{4}='bayer (gbrg)';
PATTERN{4}='bayer (grbg)';

% FACTOR = [2:2:8];
FACTOR = gain;
imOut = cell(1,length(FACTOR));

voltageSwing = 1.8;
wellCapacity = 9000;
fillfactor = 0.45;     % fill factor is the product of optical and electrical efficiency
%                       I could also achieve the same result by changing
%                       the filter tranmittance to 0.46 (optical
%                       efficiency) * 0.98 (pixel area) or 0.45
pixelSize = 2.2*1e-6*642/width;
conversiongain = voltageSwing/wellCapacity*(1/642*width)^2 * (2.^FACTOR); % in units of volts/electron
exposureDuration = 0.100 ./ (2.^FACTOR); % in seconds

switch noisetype
    case {'none','photon'}
        darkvoltage = 0; % units are volts/sec
        readnoise = 0; % units are volts
        dsnu = 0; % units are volts
        prnu = 0; % units are percent
    case 'additive'
        darkvoltage = 1e-005; % units are volts/sec
        readnoise = 1.34e-003; % units are volts
        dsnu = 14.1e-004; % units are volts
        prnu = 0; % units are percent
    case 'multiplicative'
        darkvoltage = 0; % units are volts/sec
        readnoise = 0; % units are volts
        dsnu = 0; % units are volts
        prnu = 0.002218; % units are percent
    case 'all'
        darkvoltage = 1e-005; % units are volts/sec
        readnoise = 1.34e-003; % units are volts
        dsnu = 14.1e-004; % units are volts
        prnu = 0.002218; % units are percent
end

if cfatype == 'raw'
    for k=1:length(FACTOR)

        sensor = sensorCreate(PATTERN{4});
        wave = sensorGet(sensor,'wave'); % Read in the spectral sensitivity curves for the sensor
        fullFileName = 'MeasuredSensorQE.mat';
        [data,filterNames] = ieReadColorFilter(wave,fullFileName);

        sensor = sensorSet(sensor,'filterspectra',data);
        sensor = sensorSet(sensor,'filternames',filterNames);
        sensor = sensorSet(sensor,'Name','ISETSimulationExample');
        sensor = sensorSet(sensor,'exposuretime',exposureDuration(k)); % in units of seconds
        sensor = sensorSet(sensor,'rows',height);
        sensor = sensorSet(sensor,'cols',width);
        sensor = sensorSet(sensor,'dsnulevel',dsnu);  %V (0.00172 volts or 1.7 mV
        sensor = sensorSet(sensor,'prnulevel',prnu); % specified in %
        pixel =  sensorGet(sensor,'pixel');
        pixel = pixelSet(pixel,'size',[pixelSize pixelSize]);   % Pixel Size
        pixel = pixelSet(pixel,'conversiongain', conversiongain(k));        % Volts/e-
        pixel = pixelSet(pixel,'voltageswing',voltageSwing);
        pixel = pixelSet(pixel,'darkvoltage',darkvoltage) ;
        pixel = pixelSet(pixel,'readnoisevolts',readnoise);    % units are volts

        switch noisetype
            case {'none','additive'}
                sensor = sensorSet(sensor,'shotNoiseFlag',0);
            case {'photon','multiplicative','all'}
%                 sensor = sensorSet(sensor,'shotNoiseFlag',0);
        end
        sensor = sensorSet(sensor,'quantizationmethod','analog');

        sensor = sensorSet(sensor,'pixel',pixel);
        sensor = pixelCenterFillPD(sensor,fillfactor);
        sensor = sensorCompute(sensor,oi);
        % vcAddAndSelectObject('sensor',sensor); sensorImageWindow;

        % IMAGE ###############################
        % #####################################

        vci = vcImageCreate;
        vci = imageSet(vci,'name','default');
        vci = imageSet(vci,'scaledisplay',1);
        vci = imageSet(vci,'renderGamma',0.6);
        % vci = imageSet(vci,'demosaicmethod','bilinear');
        % vci = imageSet(vci,'colorbalancemethod','none');
        vci = vcimageCompute(vci,sensor);
        % vcAddAndSelectObject(vci); vcimageWindow;

        imOut{k} = vci.data.input / vci.data.max;
    end

elseif cfatype == 'rgb'

    for k=1:length(FACTOR)

        for kk=1:3

            sensor = sensorCreate(PATTERN{kk});
            wave = sensorGet(sensor,'wave'); % Read in the spectral sensitivity curves for the sensor
            fullFileName = 'MeasuredSensorQE.mat';
            [data,filterNames] = ieReadColorFilter(wave,fullFileName);

            sensor = sensorSet(sensor,'filterspectra',data);
            sensor = sensorSet(sensor,'filternames',filterNames);
            sensor = sensorSet(sensor,'Name','ISETSimulationExample');
            sensor = sensorSet(sensor,'exposuretime',exposureDuration(k)); % in units of seconds
            sensor = sensorSet(sensor,'rows',height);
            sensor = sensorSet(sensor,'cols',width);
            sensor = sensorSet(sensor,'dsnulevel',dsnu);  %V (0.00172 volts or 1.7 mV
            sensor = sensorSet(sensor,'prnulevel',prnu); % specified in %
            pixel =  sensorGet(sensor,'pixel');
            pixel = pixelSet(pixel,'size',[pixelSize pixelSize]);   % Pixel Size
            pixel = pixelSet(pixel,'conversiongain', conversiongain(k));        % Volts/e-
            pixel = pixelSet(pixel,'voltageswing',voltageSwing);
            pixel = pixelSet(pixel,'darkvoltage',darkvoltage) ;
            pixel = pixelSet(pixel,'readnoisevolts',readnoise);    % units are volts

            switch noisetype
                case {'none','additive'}
                    sensor = sensorSet(sensor,'shotNoiseFlag',0);
                case {'photon','multiplicative','all'}
%                     sensor = sensorSet(sensor,'shotNoiseFlag',0);
            end

            sensor = sensorSet(sensor,'pixel',pixel);
            sensor = pixelCenterFillPD(sensor,fillfactor);
            sensor = sensorCompute(sensor,oi);
            % vcAddAndSelectObject('sensor',sensor); sensorImageWindow;

            % IMAGE ###############################
            % #####################################

            vci = vcImageCreate;
            vci = imageSet(vci,'name','default');
            vci = imageSet(vci,'scaledisplay',1);
            vci = imageSet(vci,'renderGamma',0.6);
            % vci = imageSet(vci,'demosaicmethod','bilinear');
            % vci = imageSet(vci,'colorbalancemethod','none');
            vci = vcimageCompute(vci,sensor);
            % vcAddAndSelectObject(vci); vcimageWindow;

            imOut{k}(:,:,kk) = vci.data.input / vci.data.max;
        end
    end

end






return