function oi = iset_get_optics(inputtype, filename, patternsize)

% SCENE ###############################
% #####################################

switch inputtype
    case 'file'
        scene = sceneFromFile(filename,'multispectral');
    case 'pattern'
        scene = sceneCreate(filename, patternsize);
end

scene = sceneAdjustLuminance(scene,61); % This sets the mean scene luminance
scene = sceneSet(scene,'fov',26.5); % match the scene field of view (fov) with the sensor fov
% vcAddAndSelectObject('scene',scene); sceneWindow; % display sceneWindow

% OPTICS ##############################
% #####################################
oi = oiCreate;
optics = oiGet(oi,'optics'); %
optics = opticsSet(optics,'fnumber',4);
optics = opticsSet(optics,'offaxis','skip');
%optics = opticsSet(optics,'offaxis','cos4th');
optics = opticsSet(optics,'focallength',3e-3);
oi = oiSet(oi,'optics',optics);
oi = oiCompute(scene,oi);
% vcAddAndSelectObject('oi',oi); oiWindow;



