clear;clc;close all;

addpath MNdemosaic BM3D bilateral scielab
load 'RAW.mat' % normalized from 0 to 1
load 'TRUE.mat' % normalized from 0 to 1

DEMOSAIC{1} = 'bilinear';
DEMOSAIC{2} = 'homogeneity';

DENOISE{1} = 'bm3d';        PARAM{1} = [40, 0];
DENOISE{2} = 'bilateral';   PARAM{2} = [4, 0.2];

imTrue = TRUE;
imTrueRAW = mosaicRGB(imTrue);

% display difference image
for k=1:length(RAW)
    imDemosaic{k} = applyDemosaic(RAW{k}, DEMOSAIC{1});
    imTemp = imTrue - imDemosaic{k};
    imErr{k} = imTemp(:,:,2);
    minErr(k) = min(imErr{k}(:));
    maxErr(k) = max(imErr{k}(:));
end

figure;  
for k=1:4
    subplot(2,2,k); imagesc(imErr{k}, [min(minErr) max(maxErr)]); axis('image'); colormap('gray');
end

% x-difference, y-difference of error image
for k=1:4
    imErrXDiff{k} = conv2(imErr{k}, [1 -1]);
    minXDiff(k) = min(imErrXDiff{k}(:));
    maxXDiff(k) = max(imErrXDiff{k}(:));
    imErrYDiff{k} = conv2(imErr{k}, [1 -1]');
    minYDiff(k) = min(imErrYDiff{k}(:));
    maxYDiff(k) = max(imErrYDiff{k}(:));
end

figure; 
for k=1:4
    subplot(2,2,k); imagesc(imErrXDiff{k}, [min(minXDiff) max(maxXDiff)]); axis('image'); colormap('gray');
end
figure;
for k=1:4
    subplot(2,2,k); imagesc(imErrYDiff{k}, [min(minYDiff) max(maxYDiff)]); axis('image'); colormap('gray');
end

% autocorrealation of error image (uniform patch)
size=40;
for k=1:4
    disp(num2str(k));
%     imPatch{k}=imErr{k}(94-size:94+size, 545-size:545+size);
   imPatch{k}=imErr{k}(155-size:155+size, 398-size:398+size);
    imErrAuto{k} = xcorr2(imPatch{k});
    minErrAuto(k) = min(imErrAuto{k}(:));
    maxErrAuto(k) = max(imErrAuto{k}(:));
end
figure; 
for k=1:4
    subplot(2,2,k); 
%     imagesc(imDemosaic{k}(94-size:94+size, 545-size:545+size)); 
   imagesc(imDemosaic{k}(155-size:155+size, 398-size:398+size)); 
    axis('image'); colormap('gray');
end
figure; 
for k=1:4
    subplot(2,2,k); imagesc(imPatch{k}); axis('image'); colormap('gray');
end
figure; 
for k=1:4
    subplot(2,2,k); imagesc(imErrAuto{k}); axis('image'); colormap('gray');
end

