clear;clc;close all;

addpath MNdemosaic BM3D bilateral scielab Pocs

% load data
load 'RAW.mat' % normalized from 0 to 1
load 'TRUE.mat' % normalized from 0 to 1
% load 'TRUE_clean.mat' % normalized from 0 to 1

DEMOSAIC{1} = 'bilinear';
DEMOSAIC{2} = 'homogeneity';
DEMOSAIC{3} = 'pocs';

DENOISE{1} = 'simple';      PARAM{1} = [0, 0];
DENOISE{2} = 'bm3d';       PARAM{2} = [40/255, 0];
DENOISE{3} = 'bilateral';   PARAM{3} = [4, 0.2];

% select algorithm
dm = 1; % demosaic
dn = 3; % denoise

imTrue = TRUE;
imTrueRAW = mosaicRGB(imTrue);
imRaw = RAW{3};

figure('Name', 'Ground Truth Image'); 
displayRGB(imTrue);

figure('Name', 'Noisy Image'); 
displayRGB(imRaw);

figure('Name', 'Ground Truth RAW Image and Noisy Image'); 
subplot(121); displayRAW(imTrueRAW);
subplot(122); displayRAW(imRaw);

% decompose images into each channel
imTrueDecompose = decomposeRAW2(imTrueRAW);
imDecompose = decomposeRAW2(imRaw);

figure('Name', 'Decomposed RAW Image'); 
subplot(311); displayRGB(imDecompose{1});
subplot(312); displayRGB(imDecompose{2});
subplot(313); displayRGB(imDecompose{3});

% denoise each channel
for c = 1:3
    fprintf(1, 'denoising channel %d...\n', c); tic;
    imDenoise{c} = applyDenoiseSingle(imDecompose{c}, DENOISE{dn}, PARAM{dn}(1), PARAM{dn}(2));
    fprintf(1, 'denoising done.(%.3f sec)\n', toc);
end

figure('Name', 'Denoised Decomposed RAW Image');
subplot(311); displayRGB(imDenoise{1});
subplot(312); displayRGB(imDenoise{2});
subplot(313); displayRGB(imDenoise{3});

% compose to RAW
imDenoiseRaw = composeRGB(imDenoise{1}, imDenoise{2}, imDenoise{3});

% demosaic image
imDemosaic = applyDemosaic(imDenoiseRaw, DEMOSAIC{dm});

figure('Name', 'Demosaic Image');
displayRGB(imDemosaic);

figure('Name', 'Noisy Demosaic Image'); 
displayRGB(applyDemosaic(imRaw, DEMOSAIC{dm}));