clear;clc;close all;

addpath MNdemosaic BM3D bilateral scielab Pocs

% Major TODOs:
% 1. print out stage in console

% load data
load 'RAW.mat' % normalized from 0 to 1
load 'TRUE.mat' % normalized from 0 to 1
% load 'TRUE_all.mat' % normalized from 0 to 1
% load 'TRUE_add.mat' % normalized from 0 to 1
% load 'TRUE_mult.mat' % normalized from 0 to 1
% load 'TRUE_photon.mat' % normalized from 0 to 1
load 'TRUE_clean.mat' % normalized from 0 to 1

DEMOSAIC{1} = 'bilinear';
DEMOSAIC{2} = 'homogeneity';
DEMOSAIC{3} = 'pocs';

DENOISE{1} = 'simple';      PARAM{1} = [0, 0];
DENOISE{2} = 'bm3d';        PARAM{2} = [20/255, 0];
DENOISE{3} = 'bilateral';   PARAM{3} = [4, 0.2];

imTrue = TRUE;
imTrueRAW = mosaicRGB(imTrue);



% im1 = double(imread('img_6917.jpg'));
% im2 = double(imread('img_6918.jpg'));
% im3=im1-im2;
% figure;
% subplot(121);imagesc(im1/255);axis('image');
% subplot(122);imagesc(im2/255);axis('image');
% figure;imagesc(truncate(abs(im3(:,:,2)/255),0,0.1));axis('image');colormap('gray');
% figure;
% displayError(im1/255,im2/255, 'viPlot');

TRUE_photon = iset_get_images('file', 'images/StuffedAnimals_tungsten-hdrs.mat', 'rgb', 'photon', [2:2:8]);
TRUE_add = iset_get_images('file', 'images/StuffedAnimals_tungsten-hdrs.mat', 'rgb', 'additive', [2:2:8]);
TRUE_mult = iset_get_images('file', 'images/StuffedAnimals_tungsten-hdrs.mat', 'rgb', 'multiplicative', [2:2:8]);
TRUE_all = iset_get_images('file', 'images/StuffedAnimals_tungsten-hdrs.mat', 'rgb', 'all', [2:2:8]);
TRUE_clean = cell2mat(iset_get_images('file', 'images/StuffedAnimals_tungsten-hdrs.mat', 'rgb', 'none', 0));

i=1;
imErr{1} = TRUE_photon{i} - TRUE_clean;
imErr{2} = TRUE_add{i} - TRUE_clean;
imErr{3} = TRUE_mult{i} - TRUE_clean;
imErr{4} = TRUE_all{i} - TRUE_clean;

imLogErr{1} = log(TRUE_photon{i}) - log(TRUE_clean);
imLogErr{2} = log(TRUE_add{i}) - log(TRUE_clean);
imLogErr{3} = log(TRUE_mult{i}) - log(TRUE_clean);
imLogErr{4} = log(TRUE_all{i}) - log(TRUE_clean);

imErrG{1} = imErr{1}(:,:,2);
imErrG{2} = imErr{2}(:,:,2);
imErrG{3} = imErr{3}(:,:,2);
imErrG{4} = imErr{4}(:,:,2);

imLogErrG{1} = truncate(imLogErr{1}(:,:,2),-.2,.2);
imLogErrG{2} = truncate(imLogErr{2}(:,:,2),-.2,.2);
imLogErrG{3} = truncate(imLogErr{3}(:,:,2),-.2,.2);
imLogErrG{4} = truncate(imLogErr{4}(:,:,2),-.2,.2);

MSE{1} = norm(imErrG{1}(:))^2;
MSE{2} = norm(imErrG{2}(:))^2;
MSE{3} = norm(imErrG{3}(:))^2;
MSE{4} = norm(imErrG{4}(:))^2;

% figure;
% subplot(221);imagesc(TRUE_all{1});axis('image');
% subplot(222);imagesc(TRUE_all{2});axis('image');
% subplot(223);imagesc(TRUE_all{3});axis('image');
% subplot(224);imagesc(TRUE_all{4});axis('image');

figure;
subplot(221);imagesc(imErrG{1});axis('image');colormap('gray'); title('photon noise');
subplot(222);imagesc(imErrG{2});axis('image');colormap('gray'); title('additive noise');
subplot(223);imagesc(imErrG{3});axis('image');colormap('gray'); title('multiplicative noise');
subplot(224);imagesc(imErrG{4});axis('image');colormap('gray'); title('all noise');

figure;
subplot(221);imagesc(imLogErrG{1});axis('image');colormap('gray'); title('photon noise');
subplot(222);imagesc(imLogErrG{2});axis('image');colormap('gray'); title('additive noise');
subplot(223);imagesc(imLogErrG{3});axis('image');colormap('gray'); title('multiplicative noise');
subplot(224);imagesc(imLogErrG{4});axis('image');colormap('gray'); title('all noise');

figure;
subplot(221);hist(imErrG{1}(:),200); title('photon noise');
subplot(222);hist(imErrG{2}(:),200); title('additive noise');
subplot(223);hist(imErrG{3}(:),200); title('multiplicative noise');
subplot(224);hist(imErrG{4}(:),200); title('all noise');

figure;
subplot(221);displayError(TRUE_all{1}, TRUE_clean, 'viPlot');
subplot(222);displayError(TRUE_all{2}, TRUE_clean, 'viPlot');
subplot(223);displayError(TRUE_all{3}, TRUE_clean, 'viPlot');
subplot(224);displayError(TRUE_all{4}, TRUE_clean, 'viPlot');

[MSE{1} MSE{2} MSE{3} MSE{4}]
