clear;clc;close all;

addpath MNdemosaic BM3D bilateral scielab Pocs

% load data
load 'images/StuffedAnimals.mat' % normalized from 0 to 1

DEMOSAIC{1} = 'bilinear';
DEMOSAIC{2} = 'homogeneity';
% DEMOSAIC{3} = 'pocs';

DENOISE{1} = 'simple';      PARAM{1} = [0, 0];
DENOISE{2} = 'cbm3d';       PARAM{2} = [40/255, 0];
DENOISE{3} = 'bilateral';   PARAM{3} = [1, 0.1];

imTrue = imData{1};
imTrueRAW = mosaicRGB(imTrue);
imTrueRAWDecompose = decomposeRAW(imTrueRAW);

BM=1; DM=0; DN=0;

if DM
for i=1:length(DEMOSAIC)
    imDemosaic{i} = applyDemosaic(imTrueRAW, DEMOSAIC{i});
end
end
if DN
for i=1:length(DENOISE)
    imDenoise{i} = applyDenoise(imData{5}, DENOISE{i}, PARAM{i}(1), PARAM{i}(2));
end
end

x=55;y=90;w=40;r=0.75;
figure(1);
subplot(221); displayRGB(imTrue(y:y+r*w,x:x+w,1)); axis off;
title('Original R Image');
subplot(222); displayRGB(imTrueRAWDecompose(y:y+r*w,x:x+w,1)); axis off;
title('Sampled R Image');
figure(2);
subplot(221); imagesc(abs(getFFT(imTrue(:,:,1))),[0 100]); axis('image'); colormap('gray'); axis off;
title('FT of Original R Image');
subplot(222); imagesc(abs(getFFT(imTrueRAWDecompose(:,:,1))),[0 100]); axis('image'); colormap('gray'); axis off;
title('FT of Sampled R Image');

figure(1);
subplot(223); displayRGB(imTrue(y:y+r*w,x:x+w,2)); axis off;
title('Original G Image');
subplot(224); displayRGB(imTrueRAWDecompose(y:y+r*w,x:x+w,2)); axis off;
title('Sampled G Image');
figure(2);
subplot(223); imagesc(abs(getFFT(imTrue(:,:,2))),[0 100]); axis('image'); colormap('gray'); axis off;
title('FT of Original G Image');
subplot(224); imagesc(abs(getFFT(imTrueRAWDecompose(:,:,2))),[0 100]); axis('image'); colormap('gray'); axis off;
title('FT of Sampled G Image');







if 0%BM
for i=1:3
    switch i
        case 1
            figure('Name','Basic Model: FFT of R Channel'); 
        case 2
            figure('Name','Basic Model: FFT of G Channel'); 
        case 3
            figure('Name','Basic Model: FFT of B Channel'); 
    end
    subplot(231); displayRGB(imTrue(:,:,i));
    subplot(232); displayRGB(imTrueRAWDecompose(:,:,i));
    subplot(233); displayRGB(imData{5}(:,:,i));
    subplot(234); imagesc(abs(getFFT(imTrue(:,:,i))),[0 100]); axis('image'); colormap('gray');
    subplot(235); imagesc(abs(getFFT(imTrueRAWDecompose(:,:,i))),[0 100]); axis('image'); colormap('gray');
    subplot(236); imagesc(abs(getFFT(imData{5}(:,:,i))),[0 100]); axis('image'); colormap('gray');
end
end

if DM
for i=1:3
    switch i
        case 1
            figure('Name','Demosaic: FFT of R Channel'); 
        case 2
            figure('Name','Demosaic: FFT of G Channel'); 
        case 3
            figure('Name','Demosaic: FFT of B Channel'); 
    end
    subplot(2,length(DEMOSAIC)+2,1); displayRGB(imTrue(:,:,i)); title('RGB, no noise');
    subplot(2,length(DEMOSAIC)+2,2); displayRGB(imTrueRAWDecompose(:,:,i)); title('RAW, no noise');
    for j=1:length(DEMOSAIC)
        subplot(2,length(DEMOSAIC)+2,j+2); displayRGB(imDemosaic{j}(:,:,i)); title(DEMOSAIC{j});
    end
    subplot(2,length(DEMOSAIC)+2,length(DEMOSAIC)+2+1); imagesc(abs(getFFT(imTrue(:,:,i))),[0 100]); axis('image'); colormap('gray');
    subplot(2,length(DEMOSAIC)+2,length(DEMOSAIC)+2+2); imagesc(abs(getFFT(imTrueRAWDecompose(:,:,i))),[0 100]); axis('image'); colormap('gray');
    for j=1:length(DEMOSAIC)
        subplot(2,length(DEMOSAIC)+2,length(DEMOSAIC)+2+j+2); imagesc(abs(getFFT(imDemosaic{j}(:,:,i))),[0 100]); axis('image'); colormap('gray');
    end
end
end

if DN
for i=1:1
    switch i
        case 1
            figure('Name','Denoise: FFT of R Channel'); 
        case 2
            figure('Name','Denoise: FFT of G Channel'); 
        case 3
            figure('Name','Denoise: FFT of B Channel'); 
    end
    subplot(2,length(DENOISE)+1,1); displayRGB(imTrue(:,:,i)); title('RGB, high noise');
    for j=1:length(DENOISE)
        subplot(2,length(DENOISE)+1,j+1); displayRGB(imDenoise{j}(:,:,i)); title(DENOISE{j});
    end
    subplot(2,length(DENOISE)+1,length(DENOISE)+1+1); imagesc(abs(getFFT(imTrue(:,:,i))),[0 100]); axis('image'); colormap('gray');
    for j=1:length(DENOISE)
        subplot(2,length(DENOISE)+1,length(DENOISE)+1+j+1); imagesc(abs(getFFT(imDenoise{j}(:,:,i))),[0 100]); axis('image'); colormap('gray');
    end
end
end
