clear;clc;close all;

addpath MNdemosaic BM3D bilateral scielab Pocs

% load data
% load 'RAW.mat' % normalized from 0 to 1
% load 'TRUE.mat' % normalized from 0 to 1
% load 'TRUE_clean.mat' % normalized from 0 to 1

DEMOSAIC{1} = 'bilinear';
DEMOSAIC{2} = 'homogeneity';
DEMOSAIC{3} = 'pocs';

DENOISE{1} = 'simple';      PARAM{1} = [0, 0];
DENOISE{2} = 'cbm3d';       PARAM{2} = [40/255, 0];
DENOISE{3} = 'bilateral';   PARAM{3} = [4, 0.2];

[imData fileName] = loadImage(1);

% true data
imTRUE = imData{1};  % ref image
imRAW = mosaicRGB(imData{1});   % clean raw image

% imTrue = TRUE;
imTrue = TRUE_clean;
imTrueRAW = mosaicRGB(imTrue);

[h w] = size(TRUE_clean(:, :));
l = w*h;

numberOfImages = length(RAW);

% select algorithm
dm = 1; % demosaic
dn = 1; % denoise

figure('Name', 'Ground Truth Image'); displayRGB(imTrue);

%%%%%%%%%%%%%%%%%%%%%
%% demosaic images %%
%%%%%%%%%%%%%%%%%%%%%
fprintf(1, '\nDemosaic Images.\n');
imDemosaicTrue = applyDemosaic(imTrueRAW, DEMOSAIC{dm});

for k=1:numberOfImages
    fprintf(1, 'demosaicking image %d...\n', k); tic;
    imDemosaic{k} = applyDemosaic(RAW{k}, DEMOSAIC{dm});
    fprintf(1, 'demosaicking done.(%.3f sec)\n', toc);
end

% display images
figure('Name', 'Demosaic True Image'); displayRGB(imDemosaicTrue);
figure('Name', 'Demosaic Images');
for k=1:numberOfImages
    subplot(2, 2, k);
    displayRGB(imDemosaic{k});
end

% display errors images
figure('Name', 'Demosaic Error Images');
for k=1:numberOfImages
    subplot(2, 2, k); 
    displayError(imDemosaic{k}, imDemosaicTrue, 'errorImage');
end

% plot demosaic errors in 3D
figure('Name', 'Demosaic Errors in RGB space');
for k=1:numberOfImages
    subplot(2, 2, k); 
    displayError(imDemosaic{k}, imDemosaicTrue, 'rgb3D');
end

% plot histogram
figure('Name', 'Demosaic Error Histograms');
for k=1:numberOfImages
    subplot(2, 2, k);
    displayError(imDemosaic{k}, imDemosaicTrue, 'histogram');
end

% plot error difference histograms
figure('Name', 'Demosaic Error Difference Histograms');
for k=1:numberOfImages
    subplot(2, 2, k);
    displayError(imDemosaic{k}, imDemosaicTrue, 'edHistogram');
end

% plot variance-intensity plots
plotType = 'viPlot';
figure('Name', 'Demosaic Variance-Intensity Plot');
for k=1:numberOfImages
    subplot(2, 2, k);
    fprintf(1, 'creating error plot(%s) for image %d...', plotType, k); tic;
    displayError(imDemosaic{k}, imTrue, plotType);
    fprintf(1, 'done.(%.3f sec)\n', toc);
end
return
%%%%%%%%%%%%%%%%%%%%
%% denoise images %%
%%%%%%%%%%%%%%%%%%%%
fprintf(1, '\nDenoise Images.\n');
imDenoiseTrue = applyDenoise(imDemosaicTrue, DENOISE{dn}, PARAM{dn}(1), PARAM{dn}(2));

for k=1:numberOfImages
    fprintf(1, 'denoising image %d...\n', k); tic;
    imDenoise{k} = applyDenoise(imDemosaic{k}, DENOISE{dn}, PARAM{dn}(1), PARAM{dn}(2));
    fprintf(1, 'denoising done.(%.3f sec)\n', toc);
end

% display images
figure('Name', 'Denoise True Image'); displayRGB(imDenoiseTrue);
figure('Name', 'Denoise Images');
for k=1:numberOfImages
    subplot(2, 2, k);
    displayRGB(imDenoise{k});
end

% % display denoise errors
% figure('Name', 'Denoise Errors');
% for k=1:numberOfImages
%     subplot(2, 2, k); 
%     displayError(imDenoise{k}, imDenoiseTrue, 'rgb3D');
% end
% 
% % plot histogram
% figure('Name', 'Denoise Error Histograms');
% for k=1:numberOfImages
%     subplot(2, 2, k);
%     displayError(imDenoise{k}, imDenoiseTrue, 'histogram');
% end

% plot variance-intensity plots
plotType = 'viPlot';
figure('Name', 'Denoise Variance-Intensity Plot');
for k=1:numberOfImages
    subplot(2, 2, k);
    fprintf(1, 'creating error plot(%s) for image %d...', plotType, k); tic;
    displayError(imDenoise{k}, imTrue, plotType);
    fprintf(1, 'done.(%.3f sec)\n', toc);
end