clear;clc;close all;

addpath MNdemosaic BM3D bilateral scielab 
addpath BLS_GSM/denoising_subprograms BLS_GSM/Simoncelli_PyrTools BLS_GSM/Added_PyrTools

load 'RAW.mat' % normalized from 0 to 1
load 'TRUE.mat' % normalized from 0 to 1

DEMOSAIC{1} = 'bilinear';
DEMOSAIC{2} = 'homogeneity';

DENOISE{1} = 'bm3d';        PARAM{1} = [40, 0];
DENOISE{2} = 'bilateral';   PARAM{2} = [4, 0.2];
DENOISE{1} = 'bls_gsm';     PARAM{1} = [10.0/255.0, 0]; % 255 for scaling the image intensity
                                                        % BLS_GSM uses images with
                                                        % imtensities between [0, 1]

imTrue = TRUE;
imTrue = double(imread('lighthouse2.tif'))/255;
imTrueRAW = mosaicRGB(imTrue);

% figure(1); subplot(211); displayRAW(imTrueRAW);
% figure(1); subplot(212); displayRGB(imTrue);

if 1
% TEST DEMOSAIC ###########################################################%

imTrue = double(imread('lighthouse2.tif'))/255;
imTrueRAW = mosaicRGB(imTrue);

for k=1:length(DEMOSAIC)
    imDemosaic{k} = applyDemosaic(imTrueRAW, DEMOSAIC{k});
    errDemosaic{k} = imTrue - imDemosaic{k};
end

figure(2); 
for k=1:length(DEMOSAIC)
    subplot(1,length(DEMOSAIC)+1, k+1); displayRGB(imDemosaic{k}); title(DEMOSAIC{k});
end
subplot(1,length(DEMOSAIC)+1,  1); displayRGB(imTrue); title('Ground truth');

figure(3);
for k=1:length(DEMOSAIC)
    subplot(1,length(DEMOSAIC), k); imshow(errDemosaic{k}); title(DEMOSAIC{k});
end

MSE = evaluateQuality(imTrue, imDemosaic, 'mse', 1);
SCIELAB = evaluateQuality(imTrue, imDemosaic, 'scielab',1);
figure; bar([MSE; SCIELAB]');

end

if 1
% TEST DENOISE ############################################################%

imTrue = applyDemosaic(RAW{3},'bilinear');

for k=1:length(DENOISE)
    imDenoise{k} = applyDenoise(imTrue, DENOISE{k}, PARAM{k}(1), PARAM{k}(2));
end

figure(4); 
for k=1:length(DENOISE)
    subplot(1,length(DENOISE)+1, k+1); displayRGB(imDenoise{k}); title(DENOISE{k});
end
subplot(1,length(DENOISE)+1,  1); displayRGB(imTrue); title('Ground truth');

end

if 1
% ANALYZE ERROR ###########################################################%

imTrue = TRUE;
imTrueRAW = mosaicRGB(imTrue);

for k=1:length(RAW)
    imDiff{k} = imTrueRAW - RAW{k};
end

figure(5);
for k=1:length(RAW)
    subplot(2,ceil(length(RAW)/2+1),k+1); displayRGB(RAW{k});
end
subplot(2,ceil(length(RAW)/2+1), 1); displayRGB(imTrueRAW);

figure(6);
for k=1:length(RAW)
%     subplot(2,ceil(length(RAW)/2),k); imshow(imDiff{k});
    subplot(length(RAW),1,k); hist(imDiff{k}(:), [-0.7:0.005:0.7]);
end

MSE = evaluateQuality(imTrueRAW, RAW, 'mse');
SCIELAB = evaluateQuality(imTrueRAW, RAW, 'scielab');
figure(7); bar([MSE; SCIELAB]');

end
