clear;clc;close all;

addpath MNdemosaic BM3D bilateral scielab
load 'RAW.mat' % normalized from 0 to 1
load 'TRUE.mat' % normalized from 0 to 1

DEMOSAIC{1} = 'bilinear';
DEMOSAIC{2} = 'homogeneity';

DENOISE{1} = 'bm3d';        PARAM{1} = [40, 0];
DENOISE{2} = 'bilateral';   PARAM{2} = [4, 0.2];

imTrue = TRUE;
imTrueRAW = mosaicRGB(imTrue);

for k=1:1
    for i=1:length(DEMOSAIC)
        imDemosaic{k,i} = applyDemosaic(RAW{k}, DEMOSAIC{i});
        [MSE1(k,i) imErrDemosaic{k,i}] = evaluateQuality(imTrue, imDemosaic{k,i}, 'mse');
        for j=1:length(DENOISE)
            imDemosaicDenoise{k,i,j} = applyDenoise(imDemosaic{k,i}, DENOISE{j}, PARAM{j}(1), PARAM{j}(2));
            [MSE2(k,i,j) imErrDemosaicDenoise{k,i,j}] = evaluateQuality(imTrue, imDemosaicDenoise{k,i,j}, 'mse');
        end
    end
end

kk=1;
for k=1:1
    for i=1:length(DEMOSAIC)
            minErr(kk) = min(min(cell2mat(imErrDemosaic{k,i})));
            maxErr(kk) = max(max(cell2mat(imErrDemosaic{k,i}))); kk = kk+1;
        for j=1:length(DENOISE)
            minErr(kk) = min(min(cell2mat(imErrDemosaicDenoise{k,i})));
            maxErr(kk) = max(max(cell2mat(imErrDemosaicDenoise{k,i,j}))); kk = kk+1;
        end
    end
end

for k=1:1
    figure;
    for i=1:length(DEMOSAIC)
        subplot(length(DEMOSAIC),length(DENOISE)+1,(i-1)*(length(DENOISE)+1)+1); imagesc(cell2mat(imErrDemosaic{k,i}), [min(minErr) max(maxErr)]); axis('image'); colormap('gray');
        for j=1:length(DENOISE)
            subplot(length(DEMOSAIC),length(DENOISE)+1,(i-1)*(length(DENOISE)+1)+j+1); imagesc(cell2mat(imErrDemosaicDenoise{k,i,j}), [min(minErr) max(maxErr)]); axis('image'); colormap('gray');
        end
    end
end
