%
% Displays the Intensity-Variance plot
%
function displayViPlot(im, imRef)
% check no. of channels
noC = size(im,3);

% get dimensions
[h w] = size(im(:, :, 1));
l = w*h;

% get error image
imErr = im-imRef;

n = zeros(256, noC);
fo = zeros(256, noC);
so = zeros(256, noC);

for c=1:noC
    for i=1:w
        for j=1:h
                x = floor(imRef(j, i, c)*255) + 1;
                
                if(x < 1) x = 1;
                elseif (x > 256) x = 256;
                end
                
                n(x, c) = n(x, c) + 1;
                fo(x, c) = fo(x, c) + im(j, i, c);
                so(x, c) = so(x, c) + im(j, i, c)*im(j, i, c);
        end
    end
end

for c = 1:noC
    for x = 1:256
        if(n(x, c) == 0) % no data available
            m(x, c) = 0;
            v(x, c) = 0;
        else
            m(x, c) = fo(x, c)/n(x, c);
            v(x, c) = so(x, c)/n(x, c) - m(x, c)*m(x, c);
        end
    end
end

x = 0:255;
if (noC == 1)
    plot(x, v(:, 1));
else
hold on; 
    plot(x, v(:, 1), 'r');
    plot(x, v(:, 2), 'g');
    plot(x, v(:, 3), 'b');
hold off;
end
xlabel('Intensity Value'); ylabel('Variance');
% axis adjusting should be done by the user
% but the x-axis should be set as 0~255