%
% Displays the projection of 'rgb3D' on to the RG/GB/BR planes
%
function displayRgbPlane(im, imRef)

% get dimensions
[h w] = size(im(:, :, 1));
l = w*h;

% get error image
imErr = im-imRef;

r = squeeze(imErr(:, :, 1));
r = reshape(r, 1, l);
g = squeeze(imErr(:, :, 2));
g = reshape(g, 1, l);
b = squeeze(imErr(:, :, 3));
b = reshape(b, 1, l);

markerSize = 1;

subplot(131); 
plot(r, g, '.', 'MarkerSize', markerSize); 
axis([-0.5 0.5 -0.5 0.5]); axis square; grid on;
xlabel('Red'); ylabel('Green'); 

subplot(132); 
plot(g, b, '.', 'MarkerSize', markerSize);
axis([-0.5 0.5 -0.5 0.5]); axis square; grid on;
xlabel('Green'); ylabel('Blue'); 

subplot(133); 
plot(b, r, 'b.', 'MarkerSize', markerSize);
axis([-0.5 0.5 -0.5 0.5]); axis square; grid on;
xlabel('Blue'); ylabel('Red'); 