function displayRgb3D(im, imRef)

% get dimensions
[h w] = size(im(:, :, 1));
l = w*h;

% get error image
imErr = im-imRef;

r = squeeze(imErr(:, :, 1));
r = reshape(r, 1, l);
g = squeeze(imErr(:, :, 2));
g = reshape(g, 1, l);
b = squeeze(imErr(:, :, 3));
b = reshape(b, 1, l);

s = ones(1, l);

% need to sub sample because Matlab can't handle too many points.
% adjust subsampling step in case image is too large
maxPoints = 1e4;
if l < maxPoints
    step = 1;
else
    step = ceil(l/maxPoints);
end

scatter3(r(1:step:l), g(1:step:l), b(1:step:l), s(1:step:l));
axis([-0.5 0.5 -0.5 0.5 -0.5 0.5]); % TODO: set range to center on origin with equal axis
axis square; axis vis3d;
xlabel('Red'); ylabel('Green'); zlabel('Blue'); % not sure of order, please verify