%
% Displays the histogram of the image
%
function displayHistogram(im)

% check no. of channels
noC = size(im,3);

% get dimensions
[h w] = size(im(:, :, 1));
l = w*h;

if(noC == 1)
v = reshape(squeeze(im(:, :)), 1, l);

hist(v, sqrt(l));
h = findobj(gca,'Type','patch');
set(h,'FaceColor','b','EdgeColor','b');
else
r = reshape(squeeze(im(:, :, 1)), 1, l);
g = reshape(squeeze(im(:, :, 2)), 1, l);
b = reshape(squeeze(im(:, :, 3)), 1, l);

subplot(131); hist(r, sqrt(l));
h = findobj(gca,'Type','patch');
set(h,'FaceColor','r','EdgeColor','r');

subplot(132); hist(g, sqrt(l));
h = findobj(gca,'Type','patch');
set(h,'FaceColor','g','EdgeColor','g');

subplot(133); hist(b, sqrt(l));
h = findobj(gca,'Type','patch');
set(h,'FaceColor','b','EdgeColor','b');
% TODO: match axes of the plots

end
