%
% Displays the autocorrelation of the image
%
function displayAutoCorPatch(im, imRef, patchSize)

% get dimensions
[h w] = size(im(:, :, 1));
l = w*h;

% get error image
imErr = im-imRef;

% get number of patches
ww = floor(w/patchSize);
hh = floor(h/patchSize);

ac = zeros(2*patchSize-1, 2*patchSize-1, 3);

for c = 1:3     
    for i = 1:ww
        for j = 1:hh
            xc = xcorr2(imErr((patchSize*(j-1)+1):patchSize*j, (patchSize*(i-1)+1):patchSize*i, c));
            ac(:, :, c) = ac(:, :, c) + xc;
        end
    end
end
        
ac = ac/(ww*hh);

subplot(1, 3, 1); displayRGB(ac(:, :, 1));
title('red');
subplot(1, 3, 2); displayRGB(ac(:, :, 2));
title('green');
subplot(1, 3, 3); displayRGB(ac(:, :, 3));
title('blue');