%
% Decomposes GRBG RAW image into separate channels.
% R, B channels are sub-sampled into each channel.
% G channel is an interpolated image. 
%
% GRBG -> RAW
% 
function imDecompose = decomposeRAW2(imRaw)

% Red
imDecompose{1} = imRaw(2:2:size(imRaw,1), 1:2:size(imRaw,2));
% Blue
imDecompose{3} = imRaw(1:2:size(imRaw,1), 2:2:size(imRaw,2));

% Green
imDecompose{2} = zeros([size(imRaw)]);
imDecompose{2}(1:2:size(imRaw,1), 1:2:size(imRaw,2)) = imRaw(1:2:size(imRaw,1), 1:2:size(imRaw,2));
imDecompose{2}(2:2:size(imRaw,1), 2:2:size(imRaw,2)) = imRaw(2:2:size(imRaw,1), 2:2:size(imRaw,2));

% Interpolate green channel
imInput = imDecompose{2};
imInput = [imInput(:,2) imInput imInput(:,size(imInput,2)-1)];
imInput = [imInput(2,:); imInput; imInput(size(imInput,1)-1,:)];
imDecompose{2} = conv2(imInput, [0 1/4 0; 1/4 1 1/4; 0 1/4 0] , 'valid');

return