% Applies denoising for single channels
%
function imDenoise = applyDenoiseSingle(img, mode, param1, param2)

addpath BM3D bilateral BLS_GSM\Simoncelli_PyrTools BLS_GSM\Added_PyrTools BLS_GSM\denoising_subprograms

% TODO: add validity check
imDenoise = img;

switch mode
    case 'simple'
        imDenoise(:,:) = conv2(imDenoise(:,:), [1/4 1/2 1/4], 'same');
        imDenoise(:,:) = conv2(imDenoise(:,:), [1/4 1/2 1/4]', 'same');
    case 'bm3d'
        if(exist('param1') == 0) sigma = 5; % TODO: estimate a reasonable value
        else sigma = param1;
        end
        [NA, imDenoise] = BM3D(1, imDenoise, sigma);
    case 'bilateral'
        if(exist('param1') == 0) sigmaSpatial = 32; 
        else sigmaSpatial = param1;
        end
        if(exist('param2') == 0) sigmaRange = 10; 
        else sigmaRange = param2;
        end
        
        imTemp = imDenoise(:,:);
        imDenoise(:,:) = bilateralFilter( imTemp, imTemp, min(imTemp(:)), max(imTemp(:)), sigmaSpatial, sigmaRange, sigmaSpatial, sigmaRange );
    case 'bls_gsm'
        if(exist('param1') == 0) sigma = 10; % TODO: estimate a reasonable value
        else sigma = param1;
        end
        
        im = squeeze(img(:, :));
        PS = ones(size(im));	% power spectral density (in this case, flat, i.e., white noise)
        seed = 0;               % random seed

        % Pyramidal representation parameters
        [Ny,Nx] = size(im);
        Nsc = ceil(log2(min(Ny,Nx)) - 4);  % Number of scales (adapted to the image size)
        Nor = 3;				            % Number of orientations (for X-Y separable wavelets it can only be 3)
        repres1 = 'uw';                     % Type of pyramid (shift-invariant version of an orthogonal wavelet, in this case)
        repres2 = 'daub1';                  % Type of wavelet (daubechies wavelet, order 2N, for 'daubN'; in this case, 'Haar')

        % Model parameters (optimized: do not change them unless you are an advanced user with a deep understanding of the theory)
        blSize = [3 3];	    % n x n coefficient neighborhood of spatial neighbors within the same subband
                            % (n must be odd): 
        parent = 0;			% including or not (1/0) in the neighborhood a coefficient from the same spatial location
                            % and orientation as the central coefficient of the n x n neighborhood, but
                            % next coarser scale. Many times helps, but not always.
        boundary = 1;		% Boundary mirror extension, to avoid boundary artifacts 
        covariance = 1;     % Full covariance matrix (1) or only diagonal elements (0).
        optim = 1;          % Bayes Least Squares solution (1), or MAP-Wiener solution in two steps (0)
        imDenoise(:, :) = denoi_BLS_GSM(im, sigma, PS, blSize, parent, boundary, Nsc, Nor, covariance, optim, repres1, repres2, seed);
end