% Applies denoise to 3 channel RGB image.
%
function imDenoise = applyDenoise(img, mode, param1, param2)

addpath BM3D bilateral BLS_GSM\Simoncelli_PyrTools BLS_GSM\Added_PyrTools BLS_GSM\denoising_subprograms

if size(img,3)==1
    imDenoise = decomposeRAW(img, 'no space');
else
    imDenoise = img;
end

switch mode
    case 'simple'
        for i=1:3
            imDenoise(:,:,i) = conv2(imDenoise(:,:,i), [1/4 1/2 1/4], 'same');
            imDenoise(:,:,i) = conv2(imDenoise(:,:,i), [1/4 1/2 1/4]', 'same');
        end
    case 'cbm3d'
        if(exist('param1') == 0) sigma = 10; % TODO: estimate a reasonable value
        else sigma = param1;
        end
        [NA, imDenoise] = CBM3D(1, imDenoise, sigma);
    case 'bilateral'
        if(exist('param1') == 0) sigmaSpatial = 32; 
        else sigmaSpatial = param1;
        end
        if(exist('param2') == 0) sigmaRange = 10; 
        else sigmaRange = param2;
        end
        for i=1:3
            imTemp = imDenoise(:,:,i);
            imDenoise(:,:,i) = bilateralFilter( imTemp, imTemp, min(imTemp(:)), max(imTemp(:)), sigmaSpatial, sigmaRange, sigmaSpatial, sigmaRange );
        end
    case 'bls_gsm'
        if(exist('param1') == 0) sigma = 10; % TODO: estimate a reasonable value
        else sigma = param1;
        end
        
        for i=1:3
            im = squeeze(img(:, :, i));
            PS = ones(size(im));	% power spectral density (in this case, flat, i.e., white noise)
            seed = 0;               % random seed

            % Pyramidal representation parameters
            [Ny,Nx] = size(im);
            Nsc = ceil(log2(min(Ny,Nx)) - 4);    % Number of scales (adapted to the image size)
            Nor = 3;				            % Number of orientations (for X-Y separable wavelets it can only be 3)
            repres1 = 'uw';                     % Type of pyramid (shift-invariant version of an orthogonal wavelet, in this case)
            repres2 = 'daub1';                  % Type of wavelet (daubechies wavelet, order 2N, for 'daubN'; in this case, 'Haar')

            % Model parameters (optimized: do not change them unless you are an advanced user with a deep understanding of the theory)
            blSize = [3 3];	    % n x n coefficient neighborhood of spatial neighbors within the same subband
                                % (n must be odd): 
            parent = 0;			% including or not (1/0) in the neighborhood a coefficient from the same spatial location
                                % and orientation as the central coefficient of the n x n neighborhood, but
                                % next coarser scale. Many times helps, but not always.
            boundary = 1;		% Boundary mirror extension, to avoid boundary artifacts 
            covariance = 1;     % Full covariance matrix (1) or only diagonal elements (0).
            optim = 1;          % Bayes Least Squares solution (1), or MAP-Wiener solution in two steps (0)
            imDenoise(:, :, i) = denoi_BLS_GSM(im, sigma, PS, blSize, parent, boundary, Nsc, Nor, covariance, optim, repres1, repres2, seed);
        end
end
