 clear all;clc;close all;
%perform data analysis for the proccessed data
addpath scielab
addpath JointDemosaic
% algorithms
%DEMOSAIC{1} = 'bilinear';
%DEMOSAIC{2} = 'homogeneity';
%DEMOSAIC{3} = 'pocs';
%DEMOSAIC{4} = 'frequency';

%DENOISE{1} = 'simple';      dn1p1 = [0 0 0 0]; dn1p2 = [0 0 0 0];       % parameters for each noise level
%DENOISE{2} = 'cbm3d';       dn2p1 = [1 5 9 13]; dn2p2 = [0 0 0 0];       % p1 - sigma, p2 - don't care
%DENOISE{3} = 'bilateral';   dn3p1 = [1 1 1 1]; dn3p2 = [0.05 0.10 0.15 0.20];     % p1 - sigma spatial, p2 - sigma range
%DENOISE{4} = 'bls_gsm';     dn4p1 = [2/255 5/255 10/255 15/255]; dn4p2 = [0 0 0 0];   % p1 - sigma, p2 - don't care

%dnParam1 = [ dn1p1; dn2p1; dn3p1; dn4p1 ];
%dnParam2 = [ dn1p2; dn2p2; dn3p2; dn4p2 ];

% display settings
displayPlots = true;

% parameter settings
% pipeline type
plType = 'JOINT';

M = zeros(1*4, 16);

count = 0;

% image number
%for imageNo = 3:3
% select noise level
%for noiseLevel = 4:4
%select DM algorithm
%for dm = 1:1
% select DN algorithm
%for dn = 1:4

imageNo=7;
[JointDem1,fileName1]=loadJointData(imageNo);


[imData fileName] = loadImage(imageNo);
imTRUE = imData{1};

for (noiseLevel=1:1)

count=count+1;
%count = count+1;
%disp(sprintf('count = %d', count));

% save settings
M(count, 1) = imageNo;
M(count, 2) = noiseLevel;
M(count, 3) = 0;
M(count, 4) = 0;

% load data


% true data
  % ref image
%imRAW = mosaicRGB(imData{1});   % clean raw image


% load JointDemosaic Result


imPro=JointDem1{noiseLevel+1};
%imPar=JointDem1Par{noiseLevel+1};




%% stage 2 - denoise %%
disp('Stage - JointDemosaicDenoise');
%tic;
% demosaic images
%imPar = applyDenoise(imPar, DENOISE{dn}, dnParam1(dn, noiseLevel), dnParam2(dn, noiseLevel)); % parallel processed clean image
%imPro = applyDenoise(imPro, DENOISE{dn}, dnParam1(dn, noiseLevel), dnParam2(dn, noiseLevel)); % processed image

% calculate errors
% 1. Clean image errors
%mse1 = evaluateJointQuality(imTRUE, imPar, 'mse');
%scielab = evaluateQuality(imTRUE, imPar, 'scielab');
%M(count, 11) = mse1;
%M(count, 12) = scielab;

% 2. True image errors
mse2 = evaluateQuality(imTRUE, imPro, 'mse');
scielab = evaluateQuality(imTRUE, imPro, 'scielab');
M(count, 13) = mse2;
M(count, 14) = scielab;

% 3. Parallel image errors
%mse3= evaluateJointQuality(imPar, imPro, 'mse');
%scielab = evaluateQuality(imPar, imPro, 'scielab');
%M(count, 15) = mse3;
%M(count, 16) = scielab;

% display images
if(displayPlots)
   

    %subplot(132); title('Parallel Image');
    %displayRGB(imPar);

    %subplot(2,2,noiseLevel); 
    subplot(1,2,1);
    %figure;
    displayRGB(imPro);
    title(['Processed Image for noise level=',num2str(noiseLevel)]);
   
    %displayRGB(imPro);
end
end
errorImg=abs(imPro-imTRUE);
figure;displayRGB(errorImg);
a=1:512;
b=ones(512,1);
k=1;
errorImgS=errorImg(:,:,1);
for i=1:64:512
    avgerr(k)=mean(mean(errorImgS(:,i:i+63)));
    k=k+1;
%end % dn
%end % dm
end % noiseLevel
plot(avgerr);
title('average error and frequency');
xlabel('frequency index');
ylabel('average error');

figure;
subplot(1,2,2); displayRGB(imTRUE);
% figure('Name', ['[Stage 2] - ' fileName]);
    title('True Image');
   
% write to file
csvwrite([plType '_' fileName '.csv'], M);

 % imageNo