% index_gen.m
%      m   size of the search area (must be odd)
%      n   size of the image patch (must be odd)

k = 10;

% indeces for navigating around Bayer pattern
numM   = (m-1)/2;       % maximum displacement for search
numN   = (n-1)/2;       % size of the image patch, max distance from center pixel
indexM = -numM:numM;    % search area index
indexN = -numN:numN;    % image patch index

% indeces used repeatedly in TLSestimate functions
%
%   nxn image patch indexing
    J = reshape(1:n^2,n,n);
    if mod(numN,2)==0
        shuffle1 = J(1:2:end,1:2:end); % color 1 downsample
        shuffle2 = J(2:2:end,2:2:end); % color 2 downsample
        shuffle3 = J(2:2:end,1:2:end); % color 3 downsample
        shuffle4 = J(1:2:end,2:2:end); % color 4 downsample
    else
        shuffle1 = J(2:2:end,2:2:end); % color 1 downsample
        shuffle2 = J(1:2:end,1:2:end); % color 2 downsample
        shuffle3 = J(1:2:end,2:2:end); % color 3 downsample
        shuffle4 = J(2:2:end,1:2:end); % color 4 downsample
    end    
    shuffle = [shuffle1(:);shuffle2(:);shuffle3(:);shuffle4(:)];
    % We use x(shuffle,:) to group the same colors together.
    
%   search area indexing (for X(i+indexM,j+indexM))
    I = reshape(1:m^2,m,m);
    
    % cross-color image patch
    t   = I(1+numM+indexN,1+numM+indexN); 
    IC0 = t(:);
    IC  = [];

    temp = min(numM-numN,8);
    if mod(numM,2)==0
        for j = -temp:2:temp
        for i = -temp:2:temp
            t = I(i+1+numM+indexN,j+1+numM+indexN);
            IC = [IC t(:)];
        end
        end
    else
        for j = -(numM-numN):2:(numM-numN)
        for i = -(numM-numN):2:(numM-numN)
            t = I(2+numM+i+indexN,2+numM+j+indexN);
            IC = [IC t(:)];
        end
        end
    end    
    
    % single-color image patches   
    if mod(numM,2)==0
        C1 = I(1:2:end,1:2:end); % color 1 downsample
        C2 = I(2:2:end,2:2:end); % color 2 downsample
        C3 = I(2:2:end,1:2:end); % color 3 downsample
        C4 = I(1:2:end,2:2:end); % color 4 downsample
    else
        C1 = I(2:2:end,2:2:end); % color 1 downsample
        C2 = I(1:2:end,1:2:end); % color 2 downsample
        C3 = I(1:2:end,2:2:end); % color 3 downsample
        C4 = I(2:2:end,1:2:end); % color 4 downsample
    end
    I1  = im2col(C1,[n,n]);
    I2  = im2col(C2,[n,n]);
    I3  = im2col(C3,[n,n]);
    I4  = im2col(C4,[n,n]);
    I12 = [I1 I2];
    I34 = [I3 I4];
    clear C1 C2 C3 C4

    % distance weights
    H   = exp(-(-numM:numM).^2/k);
    H   = H'*H;    
    H1  = H(I1((end+1)/2,:));
    H2  = H(I2((end+1)/2,:));
    H3  = H(I3((end+1)/2,:));
    H4  = H(I4((end+1)/2,:));
    H12 = H(I12((end+1)/2,:));
    H34 = H(I34((end+1)/2,:));
    clear H
    
    % TLS constraint matrix
    len1 = length(shuffle1(:));
    len2 = length(shuffle2(:));
    len3 = length(shuffle3(:));
    len4 = length(shuffle4(:));

    M1  = [            eye(len1,len1)            zeros(len1,len2-1)            zeros(len1,len3)            zeros(len1,len4-1)
                     zeros(len2,len1)  [eye(len2-1);-ones(1,len2-1)]           zeros(len2,len3)            zeros(len2,len4-1)
                     zeros(len3,len1)            zeros(len3,len2-1)              eye(len3,len3)            zeros(len3,len4-1)
                     zeros(len4,len1)            zeros(len4,len2-1)  [zeros(len4-1,len3);-ones(1,len3)] [eye(len4-1);-ones(1,len4-1)]];

    M2  = [[eye(len1-1);-ones(1,len1-1)]           zeros(len1,len2)            zeros(len1,len3)            zeros(len1,len4-1)
                     zeros(len2,len1-1)              eye(len2,len2)            zeros(len2,len3)            zeros(len2,len4-1)
                     zeros(len3,len1-1)            zeros(len3,len2)              eye(len3,len3)            zeros(len3,len4-1)
                     zeros(len4,len1-1)            zeros(len4,len2)  [zeros(len4-1,len3);-ones(1,len3)] [eye(len4-1);-ones(1,len4-1)]];

    M3  = [            eye(len1,len1)            zeros(len1,len2-1)            zeros(len1,len3)            zeros(len1,len4-1)
            [zeros(len2-1,len1);-ones(1,len1)] [eye(len2-1);-ones(1,len2-1)]       zeros(len2,len3)            zeros(len2,len4-1)
                     zeros(len3,len1)            zeros(len3,len2-1)              eye(len3,len3)            zeros(len3,len4-1)
                     zeros(len4,len1)            zeros(len4,len2-1)            zeros(len4,len3)  [eye(len4-1);-ones(1,len4-1)]];

    M4  = [            eye(len1,len1)            zeros(len1,len2-1)            zeros(len1,len3-1)            zeros(len1,len4)
            [zeros(len2-1,len1);-ones(1,len1)] [eye(len2-1);-ones(1,len2-1)]       zeros(len2,len3-1)            zeros(len2,len4)
                     zeros(len3,len1)            zeros(len3,len2-1)  [eye(len3-1);-ones(1,len3-1)]           zeros(len3,len4)
                     zeros(len4,len1)            zeros(len4,len2-1)            zeros(len4,len3-1)              eye(len4,len4) ];

    M12 = [            eye(len1,len1)            zeros(len1,len2)            zeros(len1,len3-1)            zeros(len1,len4-1)
                     zeros(len2,len1)              eye(len2,len2)            zeros(len2,len3-1)            zeros(len2,len4-1)
                     zeros(len3,len1)            zeros(len3,len2)  [eye(len3-1);-ones(1,len3-1)]           zeros(len3,len4-1)
                     zeros(len4,len1)            zeros(len4,len2)            zeros(len4,len3-1)  [eye(len4-1);-ones(1,len4-1)]];

    M34 = [[eye(len1-1);-ones(1,len1-1)]           zeros(len1,len2-1)            zeros(len1,len3)            zeros(len1,len4)
                     zeros(len2,len1-1)  [eye(len2-1);-ones(1,len2-1)]           zeros(len2,len3)            zeros(len2,len4)
                     zeros(len3,len1-1)            zeros(len3,len2-1)              eye(len3,len3)            zeros(len3,len4)
                     zeros(len4,len1-1)            zeros(len4,len2-1)            zeros(len4,len3)              eye(len4,len4) ];


M1(shuffle,:)=M1;
M2(shuffle,:)=M2;
M3(shuffle,:)=M3;
M4(shuffle,:)=M4;
M12(shuffle,:)=M12;
M34(shuffle,:)=M34;
