function [X] = TLSestimate(Y,k0,k1,n,M1,M2,M3,indexC0,indexC,index1,index2,index3)
% Y         local window of pixels
% k0,k1     noise parameters
% n         image patch size is nxn
% L         color-specific constraint matrix for TLS
% H         color-specific high-pass constraint matrix
% indexC    indeces of cross-color image patch
% indexC0   index of center patch in indexC

% general strategy
% 1) design a filter coefficient with the following properties:
%     - all-pass/denoising filter that will work if all pixels were color of interest.
%     - use M matrix constraint to pass low-frequency component from the color of interest only.
% 2) apply filter to local cross-color image patch

% internal parameters
gamma = 0.5;

% retreive image patches
S1  = Y(index1);          % downsampled image patches from color 1
S2  = Y(index2);          % downsampled image patches from color 2
S3  = Y(index3);          % downsampled image patches from color 3
SC  = Y(indexC);          % cross-color image patches
SC0 = Y(indexC0);         % center of SC patches




% mean image patches
S1_mean = mean(S1,2);
S2_mean = mean(S2,2);
S3_mean = mean(S3,2);
SC_mean = mean(SC,2);

% subtract mean from image patches
S1  = S1-S1_mean(:,ones(1,size(S1,2)));
S2  = S2-S2_mean(:,ones(1,size(S2,2)));
S3  = S3-S3_mean(:,ones(1,size(S3,2)));
SC0 = SC0-SC_mean;


a1 = size(S1,2);
a2 = size(S2,2);
a3 = size(S3,2);
a0 = a1+a2+a3;

% Q matrix
Q1 = S1*S1'; % Q matrix
Q2 = S2*S2'; % Q matrix
Q3 = S3*S3'; % Q matrix

Q0 = Q1+Q2+Q3-diag((k0+k1*S1_mean).^2*a1+(k0+k1*S2_mean).^2*a2+(k0+k1*S3_mean).^2*a3)...
    -2*k1*diag(((k0+k1*S1_mean).*sum(S1,2)*a1)+((k0+k1*S2_mean).*sum(S2,2)*a2)+((k0+k1*S3_mean).*sum(S3,2)*a3));
Q0 = Q0-diag(diag(Q0))+diag(diag(Q0)/(1+k1^2)); % estimate for clean Q matrix

Q0 = Q0+(Q0'-Q0)/2;
[V0,D0]=eig(Q0);
Q0 = V0*diag(max(diag(D0),0))*V0';

Qn = Q0+diag((k0+k1*SC_mean).^2*a0);

% P matrix
P          = [M1'*Qn*M1 M1'*Q0(:,(end+1)/2)*gamma; Q0((end+1)/2,:)*M1*gamma Q0((end+1)/2,(end+1)/2)*gamma^2];
P          = P+(P'-P)/2;
[Vp,Dp]    = eig(P);
[d,indexD] = min(diag(Dp));
V          = Vp(:,indexD);
% filter coefficients
beta  = -V(1:end-1)/(V(end)*gamma); % TLS solution
alpha = M1*beta;
X(1)  = SC0'*alpha+S1_mean((end+1)/2)'; 

% P matrix
P          = [M2'*Qn*M2 M2'*Q0(:,(end+1)/2)*gamma; Q0((end+1)/2,:)*M2*gamma Q0((end+1)/2,(end+1)/2)*gamma^2];
P          = P+(P'-P)/2;
[Vp,Dp]    = eig(P);
[d,indexD] = min(diag(Dp));
V          = Vp(:,indexD);
% filter coefficients
beta  = -V(1:end-1)/(V(end)*gamma); % TLS solution
alpha = M2*beta;
X(2)  = SC0'*alpha+S2_mean((end+1)/2)'; 

% P matrix
P          = [M3'*Qn*M3 M3'*Q0(:,(end+1)/2)*gamma; Q0((end+1)/2,:)*M3*gamma Q0((end+1)/2,(end+1)/2)*gamma^2];
P          = P+(P'-P)/2;
[Vp,Dp]    = eig(P);
[d,indexD] = min(diag(Dp));
V          = Vp(:,indexD);
% filter coefficients
beta  = -V(1:end-1)/(V(end)*gamma); % TLS solution
alpha = M3*beta;
X(3)  = SC0'*alpha+S3_mean((end+1)/2)'; 
