function [Y]= TLSdemosaic(X,k0,k1)
% G1 R
% B  G2

% With respect to the center pixel, the colors are named as follows:
%    2 3 2    
%    4 1 4
%    2 3 2
% for example, if the center pixel is B, then 1=B, 2=R, 3,4=G

% control variables
m = 25;  % size of the search area (must be odd)
n = 5 ;  % size of the image patch (must be odd)

% initialization
TLSindex;            % script file that generates indeces

X = TLSpad(X,numM);
Y = zeros(size(X));  % output preallocation
X = TLSlimit(X,11,4);
X = sum(X,3);        % input in Bayer pattern

tic
for j=numM+1:size(X,2)-numM % for each column...
    if mod(j,2)==1  % GBGBGBGB    
        for i=numM+1:size(X,1)-numM
            x = X(i+indexM,j+indexM);
            if mod(i,2)==1 % 1=G1, 2=G2, 3=B, 4=R
                Y(i,j,:) = TLSestimate(x,k0,k1,n,M4,M12,M3,IC0,IC,I4,I12,I3);
            else % 1=B, 2=R, 3=G1, 4=G2
                Y(i,j,:) = TLSestimate(x,k0,k1,n,M2,M34,M1,IC0,IC,I2,I34,I1);    
            end
        end
    else % RGRGRGRG
        for i=numM+1:size(X,1)-numM
            x = X(i+indexM,j+indexM);
            if mod(i,2)==0 % 1=G2, 2=G1, 3=R, 4=B
                Y(i,j,:) = TLSestimate(x,k0,k1,n,M3,M12,M4,IC0,IC,I3,I12,I4);
            else % 1=R, 2=B, 3=G2, 4=G1
                Y(i,j,:) = TLSestimate(x,k0,k1,n,M1,M34,M2,IC0,IC,I1,I34,I2);
            end
        end
    end
    j
    imwrite(Y/255,'tempY.bmp');
end
Y = TLSpad(Y,-numM);
toc
