function [Identified_Digits] = RunTrainAuto(DigitsToId,SegVec,NumNeeded)
    % Automatically creates training data from compact.avi for cross
    % correlation method.
    % DigitsToId - 4-dimensional image matrix (RxCx[1-3]xN)
    
    
    NumEach = zeros(1,10); %the number of each digit we have so far
    
    fprintf('AUTOMATIC OVERRIDE DETECTED. HANG ON.');
    
    %Re-order the digits so that they are all in one matrix,
    %one digit per image, as opposed to before, where one
    %frame of camera video (and all the digits) were in one image.
    TheDigits = zeros(size(DigitsToId,1),min(diff(SegVec)),size(DigitsToId,3),size(DigitsToId,4)*(length(SegVec)-1));
    for(idx = 1:(length(SegVec)-1))
        TheDigits(:,:,:,(idx-1)*size(DigitsToId,4)+1:(idx)*size(DigitsToId,4)) = DigitsToId(:,SegVec(idx):SegVec(idx)+min(diff(SegVec))-1,:,:);
    end
    while(min(NumEach)<NumNeeded)
        TheIdx = randint(1,1,[1,size(TheDigits,4)]); %pick a digit, any digit
        WhichDigit = floor((TheIdx-1)/100); %this is what it should be
        NumEach(WhichDigit+1) = NumEach(WhichDigit+1) + 1; %increment the counter
        
        %Store the images
        Identified_Digits{WhichDigit+1}.TheImage{NumEach(WhichDigit+1)} = TheDigits(:,:,:,TheIdx); 
    end
end