function [Identified_Digits] = RunTrain(DigitsToId,SegVec,NumNeeded)
    % Training for Cross-Correlation Method
    % DigitsToId - 4-dimensional image matrix (RxCx[1-3]xN)
    
    FIG_TRAIN = 200;
    FIG_STATUS = 201;
    figure(FIG_TRAIN);
    NumEach = zeros(1,10); %the number of each digit we have so far
    
    fprintf('We need to find at least %g of every digit for this\n',NumNeeded);
    fprintf('to work properly.  I\''m going to show you a bunch\n');
    fprintf('of images, and ask you to identify each one. I\''ll keep\n');
    fprintf('track of what\''s going on, and stop you when I have enough.\n');
    
    %Re-order the digits so that they are all in one matrix,
    %one digit per image, as opposed to before, where one
    %frame of camera video (and all the digits) were in one image.
    TheDigits = zeros(size(DigitsToId,1),min(diff(SegVec)),size(DigitsToId,3),size(DigitsToId,4)*(length(SegVec)-1));
    for(idx = 1:(length(SegVec)-1))
        TheDigits(:,:,:,(idx-1)*size(DigitsToId,4)+1:(idx)*size(DigitsToId,4)) = DigitsToId(:,SegVec(idx):SegVec(idx)+min(diff(SegVec))-1,:,:);
    end
    while(min(NumEach)<NumNeeded)
        figure(FIG_STATUS);
        bar(0:9,NumEach); %keep track of how many of each digit we've found
        figure(FIG_TRAIN);
        TheIdx = randint(1,1,[1,size(TheDigits,4)]); %pick a digit, any digit
        imagesc(TheDigits(:,:,:,TheIdx)); %show it to the user
        axis image;
        if(size(DigitsToId,3)==1) %in case the image is grayscale
            colormap gray;
        end
        WhichDigit = input('What digit do you see? (Enter out of 0-9 range to skip) ');
        if(WhichDigit < 0 || WhichDigit > 9)
            warning('Oops!  Out of range.  Skipping.')
        else
            NumEach(WhichDigit+1) = NumEach(WhichDigit+1) + 1;
            % store the identified image in a cell array
            Identified_Digits{WhichDigit+1}.TheImage{NumEach(WhichDigit+1)} = TheDigits(:,:,:,TheIdx);
        end    
    end
    close(FIG_TRAIN);
    close(FIG_STATUS);
end