%Neural Net Method, Feature Extractor
%Requires "training_patterns" subdirectory
clear all;
close all;

NUM_DIGITS = 10;
NUM_PARAMS = 7;
training_files = dir('training_patterns/*.tif');

parameters = zeros(NUM_PARAMS,size(training_files,1));
targets = zeros(NUM_DIGITS,size(training_files,1));
count = 1;
err = [];

for(idx = 1:size(training_files,1))
    %for each pattern
    fprintf('%4g',idx);
    fn = sprintf('training_patterns/%s',training_files(idx).name);

    %pull the information out of the filename (h, d, etc.)
    d = (regexp(regexp(fn,'_d\d{1,2}_','match'),'\d{1,2}','match'));
    d = str2double(d{1});
    h = (regexp(regexp(fn,'_h\d{1,2}_','match'),'\d{1,2}','match'));
    h = str2double(h{1});
    T = (regexp(regexp(fn,'_T\d{1,2}','match'),'\d{1,2}','match'));
    T = str2double(T{1});
    N = (regexp(regexp(fn,'_\d{1,2}_','match'),'\d{1,2}','match'));
    N = str2double(N{1});

    img = imread(fn);
    
    %BEGIN DOWNSAMPLE
    %img = img(1:2:end,1:4:end,:);
    %END DOWNSAMPLE
    
    %scale to binary 0/1 image
    img(img==255) = 1;
    
    %make it a double and invert for regionprops compatibility
    img = double(~img);
    imagesc(img);
    axis image; colormap jet; axis off;

    %pull everything and the kitchen sink
    temp = regionprops(img,'Area','EulerNumber','Orientation',...              
      'BoundingBox'   ,    'Extent'   ,         'Perimeter',...          
      'Centroid'    ,      'Extrema'     ,      'PixelIdxList',... 
      'ConvexArea'   ,     'FilledArea'   ,     'PixelList',...
      'ConvexHull'   ,     'FilledImage'  ,     'Solidity',...
      'ConvexImage'    ,   'Image'     ,        'SubarrayIdx',...            
      'Eccentricity'  ,    'MajorAxisLength',... 
      'EquivDiameter'  ,   'MinorAxisLength');

    parameters(1:2,count) = temp.Centroid;
    parameters(3,count)   = temp.Perimeter;
    parameters(4,count)   = temp.MajorAxisLength;
    parameters(5,count)   = temp.MinorAxisLength;
    parameters(6,count)   = temp.Eccentricity;
    parameters(7,count)   = temp.Orientation;

    targets(N+1,count) = 1;

    count = count+1;
    fprintf('\b\b\b\b');
end


% Run the following code after running the NN toolbox!
% [y,i] = max(output);
% i = i - 1;
% CorrectVec = repmat(0:1:9,100,1);
% CorrectVec = CorrectVec(:);
% MSE = mean((CorrectVec - i').^2)

