% Take the ten digit images and add perspective to them, simulating
% different camera angles
% Requires 0.tif through 9.tif to be in the same directory, and that
% "train" subdirectory be created
clear all;
close all;

digDims = size(rgb2gray(imread('0.tif')));

[x,y] = meshgrid(1:digDims(2),1:digDims(1));
x = (x - digDims(2)/2)./1000;
y = (y - digDims(1)/2)./1000;

THETA_DC = 90; %rotate 90 degrees, plus or minus THETA_AC
                %DC rotation takes care of the fact that the images
                %are of upright, and not sideways, digits
h = 2; %fixed "camera height" of 2

for(d = 1:1:10)
    for(THETA_AC = 0:10:90)
        digMat = zeros([digDims 10]);
        for(i=1:1:10)
            %read in the image, which must be in the same directory
            digMat(:,:,i) = rgb2gray(imread(sprintf('%g.tif',i-1)));
            
            %binarize the image
            tempImage = digMat(:,:,i);
            tempImage(tempImage<255) = 0;
            tempImage(tempImage==255) = 1;
            
            %rotate it first
            digMat(:,:,i) = ~imrotate(~tempImage,THETA_DC + THETA_AC,'crop');
            
            %compute transform coordinates
            xp = (d*x)./(y+d);
            yp = h - (d*h)./(y+d);
            
            %find the range of the transform coordinates
            minXP = min(xp(:)); maxXP = max(xp(:));
            minYP = min(yp(:)); maxYP = max(yp(:));
            [xn,yn] = meshgrid(linspace(minXP,maxXP,digDims(2)),linspace(minYP,maxYP,digDims(1)));
            
            %interpolate to create a pixel image
            digMat(:,:,i) = griddata(xp,yp,digMat(:,:,i),xn,yn);
            digMat(isnan(digMat)) = 1; %kill off NaNs.
            
            %rotate back the DC component.
            digMat(:,:,i) = ~imrotate(~digMat(:,:,i),-(THETA_DC+THETA_AC),'crop');
            
            %write out the result in the "train" folder
            %the filename contains the information about d, h, etc.
            imwrite(digMat(:,:,i),sprintf('train/DIGIT_%g_h%g_d%g_T%g.tif',i-1,h,d,THETA_AC),'tiff','Compression','none');
        end
    end
end    