function Digit = GuessDigit(TOP_SEG,BOTTOM_SEG,MIDDLE_SEG,LT_SEG,LB_SEG,RT_SEG,RB_SEG)
%this function is for the "Smart-strokes" algorithm--it determines which
%digit is shown based on which segments are illuminated

    global DEBUG_FIG;
    global DEBUG_ON;
    
    %what percentage "filled" determines if a segment is illuminated?
    FILL_THRESH = 0.4;
    
    %binarize the segments according to the percentage-filled threshold
    %defined above
    TopFill = (sum(TOP_SEG(:))./prod(size(TOP_SEG)))>FILL_THRESH;
    BottomFill = (sum(BOTTOM_SEG(:))./prod(size(BOTTOM_SEG)))>FILL_THRESH;
    MiddleFill = (sum(MIDDLE_SEG(:))./prod(size(MIDDLE_SEG)))>FILL_THRESH;
    LTFill = (sum(LT_SEG(:))./prod(size(LT_SEG)))>FILL_THRESH;
    LBFill = (sum(LB_SEG(:))./prod(size(LB_SEG)))>FILL_THRESH;
    RTFill = (sum(RT_SEG(:))./prod(size(RT_SEG)))>FILL_THRESH;
    RBFill = (sum(RB_SEG(:))./prod(size(RB_SEG)))>FILL_THRESH;
    
    if(DEBUG_ON)
       figure(DEBUG_FIG);
       subplot(331);
       title(sprintf('%g',LTFill));
       subplot(332);
       title(sprintf('%g',TopFill));
       subplot(335);
       title(sprintf('%g',MiddleFill));
       subplot(338);
       title(sprintf('%g',BottomFill));
       subplot(337);
       title(sprintf('%g',LBFill));
       subplot(333);
       title(sprintf('%g',RTFill));
       subplot(339);
       title(sprintf('%g',RBFill));
    end
    
    %form our vector in "feature space"
    FillPattern = [TopFill; BottomFill; MiddleFill; LTFill; LBFill; RTFill; RBFill];
    
    P = 1; N = 0;
        
    FillMatrix = [P,P,N,P,P,P,P     ; %0
                  P,P,P,N,P,P,N     ; %2
                  P,P,P,N,N,P,P     ; %3
                  N,N,P,P,N,P,P     ; %4
                  P,P,P,P,N,N,P     ; %5
                  P,P,P,P,P,N,P     ; %6
                  P,N,N,N,N,P,P     ; %7
                  P,P,P,P,P,P,P     ; %8
                  P,P,P,P,N,P,P]    ; %9
    
    Digit = 0;
    Distance = 999999;
    
    % Nearest neighbor guess
    for(jdx = 1:size(FillMatrix,1))
        NewDistance = norm(FillMatrix(jdx,:)-FillPattern');
        if(NewDistance < Distance)
            Distance = NewDistance;
            Digit = jdx;
        end
    end
    if(Digit==1)
        Digit = 0;
    end
end