% Generate 10 digits, zero through nine
clear all; close all;
figure('position',[0 0 300 375]);
for(i=0:9)
    theLED = led7('BackgroundColor', 'k', ...
              'Blanking',        'yes', ...
              'Digits',          1, ...
              'Format',          '%g', ...
              'OffColor',        [0 0 0], ...
              'OnColor',         [1 0 0], ...
              'Parent',          gcf, ...
              'Position',        [0 0 1 1], ...
              'SelectColor',     'g', ...
              'SelectDigit',     [], ...
              'Style',           'traditional', ...
              'Units',           get(0,'defaultaxesunits'), ...
              'Value',           i);
     %dump the figure to a "fake" printer
     set(gcf,'PaperPositionMode','auto')     
     print('-dtiffnocompression',sprintf('%g.tif',i));
     delete(theLED);
     clear theLED;
end
