%Psych 221 Final Project: EyeLab
%Mozziyar Etemadi
%2009

clc;
clear all;
close all;

global DEBUG_ON; 
DEBUG_ON = 0; %Set to 1 to view verbose debug information
global DEBUG_FIG;
DEBUG_FIG = 60; %Figure index for debug info

PREV_FIG = 100; %Preview Figure
ISOL_FIG = 101; %Isolation Figure

fprintf('Welcome to EyeLab.  This system will help you process video\n');
fprintf('to record numbers from test equipment.  The first step is to\n');
fprintf('pick a video file to analyze.\n');

fprintf('\nPress any key to continue...\n');
pause;

[filename, pathname, filterindex] = uigetfile('*.avi', 'Pick a Movie');
if(filename==0)
    error('You did not choose a file!');
end

fprintf('Thanks.  Let\''s look at a preview.  I\''m going to pick a frame\n');
fprintf('in the middle. Here are some statistics:\n\n');

%use "help mmreader" for more information
theReader = mmreader(sprintf('%s%s',pathname,filename));
theFrames = read(theReader);

% DOWNSAMPLE FOR SIMULATION
% theFrames = theFrames(1:4:end,1:4:end,:,:);
% END DOWNSAMPLE

fprintf('File name: %s\n',filename);
fprintf('Number of frames: %g\n',size(theFrames,4));
fprintf('Frame rows: %g\n',size(theFrames,1));
fprintf('Frame cols: %g\n',size(theFrames,2));

figure(PREV_FIG);
QuadPreview(PREV_FIG,theFrames(:,:,:,round(size(theFrames,4)/2)));

fprintf('Okay.  Now we\''re going to isolate the digits.\n');
fprintf('\nPress any key to continue...\n');
pause;

figure(ISOL_FIG);
%choose a frame right in the middle of the video, this avoids bumps that
%may occur when the user hits the "record" button to start or stop the
%camera
imagesc(theFrames(:,:,:,round(size(theFrames,4)/2)));
axis image; colormap gray;

fprintf('Click on the upper left corner of ALL the digits.\n');
[Ux,Uy] = ginput(1); Ux = round(Ux); Uy = round(Uy);
fprintf('Click on the bottom right corner of ALL the digits.\n');
[Bx,By] = ginput(1); Bx = round(Bx); By = round(By);

clf;
%crop the video
theFrames = theFrames(Uy:By,Ux:Bx,:,:);
imagesc(theFrames(:,:,:,round(size(theFrames,4)/2)));
axis image; colormap gray;

NumDigits = input('How many digits are there? ');
ScaleFac = round([0:NumDigits]./NumDigits*size(theFrames,2));
ScaleFac(1) = 1;
%ScaleFac now contains column indices that identify the location of the
%digits.  For example ScaleFac(1):ScaleFac(2) are the columns of the first
%digit.

for(idx = 1:NumDigits)
    subplot(1,NumDigits,idx);
    imagesc(theFrames(:,ScaleFac(idx):ScaleFac(idx+1),:,round(size(theFrames,4)/2))); axis image;
    title(sprintf('Digit %g',idx));
end
fprintf('Please verify that you can see each digit in a separate plot.\n')
fprintf('If this is the case, can you please tell me which digit contains\n')
DecDigit = input(('the decimal point? '));

close all;
figure(PREV_FIG);
imagesc(theFrames(:,ScaleFac(DecDigit):ScaleFac(DecDigit+1),:,round(size(theFrames,4)/2)));
DecAfter = input('Does the decimal point occur after the digit (Y/N)? ','S') == 'Y';
fprintf('Thanks.  We\''re going to eliminate the decimal.  Please select\n');
fprintf('the upper right corner of it.\n');
[Ux,Uy] = ginput(1); Ux = ScaleFac(DecDigit) + round(Ux); Uy = round(Uy);
fprintf('Click on the bottom right corner of the decimal.  Don\''t worry\n');
fprintf('about going off screen.\n');
[Bx,By] = ginput(1); Bx = ScaleFac(DecDigit) + round(Bx); By = round(By);
Bx = min(size(theFrames,2),Bx);
By = min(size(theFrames,1),By);

%zero out the decimal to avoid interfering with the bounding box
theFrames(Uy:By,Ux:Bx,:,:) = 0;

QuadPreview(PREV_FIG,theFrames(:,:,:,round(size(theFrames,4)/2)));
fprintf('Alright.  We need to binarize the digits.\n');
ImgColor = input('What color are they (R/G/B)? ','S');
switch ImgColor
    case{'R'}
        ImgColor = 1;
    case{'G'}
        ImgColor = 2;
    case{'B'}
        ImgColor = 3;
    otherwise
        error('You did not enter a valid color!');
end
theFrames = theFrames(:,:,ImgColor,:);
theFrames = theFrames./255;
theFrames(theFrames > .8) = 1;
theFrames(theFrames <=.8) = 0;
clf;
imagesc(theFrames(:,:,1,round(size(theFrames,4)/2)));
axis image; colormap gray;

fprintf('Okay.  Now that we have the digits, you need to choose an algorithm\n');
fprintf('to use to ID the digits.\n');
AlgChoice = MakeMenu('Algorithm Selection',{'Smart Strokes','Feature Extraction/Neural Net','Cross Correlator'});

tic;
switch AlgChoice
    case {1}
        fprintf('Welcome to Smart Strokes.  Here goes...\n');
        DoneData = zeros(size(theFrames,4),NumDigits);
        for(idx = 1:size(theFrames,4))
            for(jdx = 1:NumDigits)
               BUFFER_FACTOR = .2; %adjusts the "width" of the strokes
               
               timg = theFrames(:,ScaleFac(jdx):ScaleFac(jdx+1),:,idx);
               
               if(sum(timg(:))./prod(size(timg)) > 0.02) %make sure the image isn't blank
                   temp = regionprops(timg,'BoundingBox');
                   temp.BoundingBox = round(temp.BoundingBox);
                   if(temp.BoundingBox(4) < temp.BoundingBox(3)*2.5) %check if it's a "one"
                       bottom = max(temp.BoundingBox(2),1);
                       top = min(temp.BoundingBox(2)+temp.BoundingBox(4),size(timg,1));
                       left = max(temp.BoundingBox(1),1);
                       right = min(temp.BoundingBox(1)+temp.BoundingBox(3),size(timg,2));
                       timg = timg(bottom:top,left:right);

                       [RSz,CSz] = size(timg);

                       %retrieve image segments
                       
                       TOP_SEG = timg(1:round(RSz*BUFFER_FACTOR/2),:);
                       BOTTOM_SEG = flipud(timg(end:-1:round(RSz*(1-BUFFER_FACTOR/2)),:));
                       MIDDLE_SEG = timg(round(RSz/2-RSz*BUFFER_FACTOR/4):round(RSz/2+RSz*BUFFER_FACTOR/4),round(CSz*BUFFER_FACTOR):end-round(CSz*BUFFER_FACTOR));

                       LT_SEG = timg(1:round(RSz/2),1:round(CSz*BUFFER_FACTOR));
                       LB_SEG = timg(round(RSz/2)+1:end,1:round(CSz*BUFFER_FACTOR));
                       RT_SEG = fliplr(timg(1:round(RSz/2),end:-1:round(CSz*(1-BUFFER_FACTOR))));
                       RB_SEG = fliplr(timg(round(RSz/2)+1:end,end:-1:round(CSz*(1-BUFFER_FACTOR))));

                       if(DEBUG_ON)
                           figure(DEBUG_FIG);
                           subplot(331);
                           imagesc(LT_SEG); axis image;
                           subplot(332);
                           imagesc(TOP_SEG); axis image;
                           subplot(335);
                           imagesc(MIDDLE_SEG); axis image;
                           subplot(338);
                           imagesc(BOTTOM_SEG); axis image;
                           subplot(337);
                           imagesc(LB_SEG); axis image;
                           subplot(333);
                           imagesc(RT_SEG); axis image;
                           subplot(339);
                           imagesc(RB_SEG); axis image;
                       end
                       guess = GuessDigit(TOP_SEG,BOTTOM_SEG,MIDDLE_SEG,LT_SEG,LB_SEG,RT_SEG,RB_SEG);
                   else
                       guess = 1;
                   end
                   if(DEBUG_ON)
                       figure(DEBUG_FIG);
                       subplot(334);
                       title(sprintf('%g',guess));
                       pause;
                   end

                   if(guess==-1) %this should never occur (legacy feature
                                         % left over from older version)
                       if(idx==1) %if we've never guessed anything before
                           guess = 0; %guess a zero
                       else %if we've just guessed something
                           guess = DoneData(idx-1,jdx); %guess that this 
                                       %unknown digit is the same as before
                       end
                   end
               else
                   %the image is blank
                   guess = 0;
               end
               DoneData(idx,jdx) = guess;  
            end
            if(DEBUG_ON)
                figure(PREV_FIG);
                imagesc(theFrames(:,:,1,idx));
                axis image; colormap gray;
                title(mat2str(DoneData(idx,:)));
                pause;
            end
        end
    case {2}
        fprintf('Welcome to the Neural Network Approach. This could get hairy...\n');
        error('The Neural Net approach is implemented with PullParameters.m and the Neural Net Toolbox!');
    case {3}
        fprintf('Welcome to the Cross Correlation method.\n');
        DoneData = zeros(size(theFrames,4),NumDigits);
        
        %query user for training patterns
        ID_Dig = RunTrain(theFrames,ScaleFac,2);
        for(idx = 1:10)
            for(jdx = 1:length(ID_Dig{idx}.TheImage))
                timg = ID_Dig{idx}.TheImage{jdx};
                temp = regionprops(timg,'BoundingBox');
                temp.BoundingBox = round(temp.BoundingBox);
                bottom = max(temp.BoundingBox(2),1);
                top = min(temp.BoundingBox(2)+temp.BoundingBox(4),size(timg,1));
                left = max(temp.BoundingBox(1),1);
                right = min(temp.BoundingBox(1)+temp.BoundingBox(3),size(timg,2));
                
                %crop image
                timg = timg(bottom:top,left:right);
                
                %resample to fixed grid size to facilitate scale invariance
                [X,Y] = meshgrid(linspace(1,100,size(timg,2)),linspace(1,100,size(timg,1)));
                [XI,YI] = meshgrid(linspace(1,100,40),linspace(1,100,70));
                timg = interp2(X,Y,double(timg),XI,YI);
                
                %store brightness-normalized image over the original
                ID_Dig{idx}.TheImage{jdx} = (timg-mean(timg(:)))/std(timg(:));
                
                %take DCT of brightness-normalized image
                ID_Dig{idx}.TheDCT{jdx} = dct(ID_Dig{idx}.TheImage{jdx});
            end
        end
        for(idx = 1:size(theFrames,4))
            %status indicator
            fprintf('%4g/%4g',idx,size(theFrames,4));
            
            for(jdx = 1:NumDigits)
               timg = theFrames(:,ScaleFac(jdx):ScaleFac(jdx+1),:,idx);
               if(sum(timg(:))./prod(size(timg)) > 0.02)
                   temp = regionprops(timg,'BoundingBox');
                   temp.BoundingBox = round(temp.BoundingBox);
                   bottom = max(temp.BoundingBox(2),1);
                   top = min(temp.BoundingBox(2)+temp.BoundingBox(4),size(timg,1));
                   left = max(temp.BoundingBox(1),1);
                   right = min(temp.BoundingBox(1)+temp.BoundingBox(3),size(timg,2));
                   %crop image
                   timg = timg(bottom:top,left:right);
                   
                   %resample image for scale invariance
                   [X,Y] = meshgrid(linspace(1,100,size(timg,2)),linspace(1,100,size(timg,1)));
                   [XI,YI] = meshgrid(linspace(1,100,40),linspace(1,100,70));
                   timg = interp2(X,Y,double(timg),XI,YI);
                   CorrVec = zeros(1,10); %vector to store average norms
                   for(kdx = 1:10) %for each digit possibility
                       for(ldx = 1:length(ID_Dig{kdx}.TheDCT))
                            %loop through all the matched filters for
                            %each digit.  minimum of two!
                           CorrVec(kdx) = CorrVec(kdx) + sum(sum((dct(timg).*ID_Dig{kdx}.TheDCT{ldx})));
                       end
                       %finish the mean by dividing by the total number
                       CorrVec(kdx) = CorrVec(kdx)./length(ID_Dig{kdx}.TheDCT);
                   end
                   [junk,WhichDig] = max(CorrVec); 
                   DoneData(idx,jdx) = WhichDig - 1;
               else
                   %blank digit
                   DoneData(idx,jdx) = 0;
               end
               if(DEBUG_ON)
                   figure(PREV_FIG);
                   subplot(211);
                   bar(0:9,CorrVec);
                   subplot(212);
                   imagesc(timg); axis image;
                   title(sprintf('%g',WhichDig-1));
               end
            end
            fprintf('\b\b\b\b\b\b\b\b\b');
        end
        fprintf('\n');
end

toc

%convert the matrix to a time trace
DoneVec = zeros(size(DoneData,1),1);
for(idx = 1:length(DoneVec))
    tempStr = '';
    for(jdx = 1:NumDigits)
        tempStr = sprintf('%s%1g',tempStr,DoneData(idx,jdx));
    end
    DoneVec(idx) = str2double(tempStr);
end

%time vector formed from the frame rate of the video
TimeVec = [0:length(DoneVec)-1].*1/get(theReader,'FrameRate');

figure;
plot(TimeVec,DoneVec);
xlabel('Time (s)');