function testGrayScaleWindow(M,subject)

% clear all
% close all
%%%%% tests -- windowing %%%%%%%

WIDTH  = size(M,1);
HEIGHT = size(M,2);
FRAMES = size(M,3);

CSV=csvread(strcat('subject', subject, '.oct');

%%%%% Defining the windows for the eyes and the mouth

rightEyeX=CSV(1:FRAMES,12);
rightEyeY=CSV(1:FRAMES,13);
leftEyeX=CSV(1:FRAMES,14);
leftEyeY=CSV(1:FRAMES,15);

widthEye=leftEyeX-rightEyeX;

eyeWindowX=[rightEyeX-floor(widthEye/2) leftEyeX+floor(widthEye/2)];
eyeWindowY=[min([leftEyeY';rightEyeY'])'-floor(widthEye/2) max([leftEyeY';rightEyeY'])'+floor(widthEye/2)];

rightMouthX=CSV(1:FRAMES,20);
rightMouthY=CSV(1:FRAMES,21);
leftMouthX=CSV(1:FRAMES,22);
leftMouthY=CSV(1:FRAMES,23);

widthMouth=leftMouthX-rightMouthX;

mouthWindowX=[rightMouthX-floor(widthMouth/2) leftMouthX+floor(widthMouth/2)];
mouthWindowY=[min([leftMouthY';rightMouthY'])'-floor(widthMouth/2) max([leftMouthY';rightMouthY'])'+floor(widthMouth/2)];

%%%%%% Generating the videos %%%%%%%%%%%%%%%%

%M=RGBread('subject50.v',WIDTH,HEIGHT,FRAMES);
scaledGscale=zeros(HEIGHT,WIDTH,FRAMES);
%maxVar=zeros(HEIGHT,WIDTH,FRAMES);

for i=1:FRAMES
    
    
%%%%%% Scaled Grayscale   %%%%%%%%% 
    scaledGscale(:,:,i)=rgb2gray(M(:,:,3*(i-1)+1:3*i)); 

%%%%%% Maximum Variance Projection   %%%%%%%%%
%     maxVar(:,:,i)=projMaxVar(M(:,:,3*(i-1)+1:3*i));
%     
%     if i>1 && eyeWindowY(i-1,1)>0
%         eyeWindow=M(eyeWindowY(i-1,1):eyeWindowY(i-1,2),eyeWindowX(i-1,1):eyeWindowX(i-1,2),3*(i-1)+1:3*i);
%         mouthWindow=M(mouthWindowY(i-1,1):mouthWindowY(i-1,2),mouthWindowX(i-1,1):mouthWindowX(i-1,2),3*(i-1)+1:3*i);
%         
%         eyeWmv=projMaxVar(eyeWindow);
%         mouthWmv=projMaxVar(mouthWindow);
%         
%         eyeWsg=rgb2gray(eyeWindow);
%         mouthWsg=rgb2gray(mouthWindow);
%         
%         maxVar(eyeWindowY(i-1,1):eyeWindowY(i-1,2),eyeWindowX(i-1,1):eyeWindowX(i-1,2),i)=eyeWmv;
%         maxVar(mouthWindowY(i-1,1):mouthWindowY(i-1,2),mouthWindowX(i-1,1):mouthWindowX(i-1,2),i)=mouthWmv;
%         
% %        scaledGscale(eyeWindowY(i-1,1):eyeWindowY(i-1,2),eyeWindowX(i-1,1):eyeWindowX(i-1,2),i)=eyeWsg;
% %        scaledGscale(mouthWindowY(i-1,1):mouthWindowY(i-1,2),mouthWindowX(i-1,1):mouthWindowX(i-1,2),i)=mouthWsg;
%         
%     end
    
    
end

%%%% Output videos %%%%%%%%%%%%%%%%%%%%%

scaledGscale=scaledGscale/255;

%GRAYwrite('Scaled_Gscale_W_50.avi',scaledGscale,200);
makeMovieGray(strcat('Scaled_Gscale_W_', subject),scaledGscale);

clear scaledGscale;

