%%% image must be int 8 rgb

function [im2,M]=projMaxVar(image)

[m,n,k]=size(image);
image=double(image);

% Calculate the mean [rgb]
R=image(:,:,1);
G=image(:,:,2);
B=image(:,:,3);

Rbar=mean(R(:));
Gbar=mean(G(:));
Bbar=mean(B(:));

Xbar=[Rbar;Gbar;Bbar];

% Calculate the variance matrix
sigma=0;
for i=1:m
    for j=1:n
        X=[image(i,j,1) ;image(i,j,2) ;image(i,j,3)];
        sigma=sigma+(X-Xbar)*(X-Xbar)';
    end
end
sigma=sigma/(m*n);

[U,S,V]=svd(sigma);
U=-U;

im2=zeros(m,n);
for i=1:m
    for j=1:n
        X=[image(i,j,1) ;image(i,j,2) ;image(i,j,3)];
        y=U'*X;
        im2(i,j)=y(1);
    end
end

mini=min(im2(:));
maxi=max(im2(:));
im2=((im2-mini)/(maxi-mini));

M=U';