function Mout=prinCompNW(M)

% clear all
% close all
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 
%   Principal Components Method -- scaled to have results between 0 and 1
%   WITHOUT windowing
%   Grayscale output with 3x replicated frames
%   M is the output of RGBread
%   CSV=csvread('subject50.csv');
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%%%%%%%%%%%%%% Set Parameters %%%%%%%%%%%%%%%%%
[HEIGHT,WIDTH,FRAMES] = size(M);

maxVar=zeros(HEIGHT,WIDTH,FRAMES/3);

for i=1:FRAMES/3 

%%%%%% Maximum Variance Projection   %%%%%%%%%

    [X,R] = imstack2vectors(M(:,:,3*(i-1)+1:3*i));
    P = princomp(X, 3);
    F=reshape(P.Y(:,1), HEIGHT, WIDTH);
    maxVar(:,:,i)=(F-min(F(:)))/(max(F(:)-min(F(:))));
     
end

%%%% Output videos %%%%%%%%%%%%%%%%%%%%%

% maxVar=reshape([maxVar maxVar maxVar],HEIGHT,FRAMES*WIDTH);
% maxVar=reshape(maxVar,HEIGHT,WIDTH,FRAMES);

Mout=maxVar;
end